package com.els.base.core.web.interceptor;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import com.els.base.core.entity.project.Project;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.project.ProjectUtils;


public class ProjectInitInterceptor extends HandlerInterceptorAdapter {
	private Logger logger = LoggerFactory.getLogger(ProjectInitInterceptor.class);
	
	@Resource
	protected ProjectService projectService;
	
	@Value("${project.interceptor.enable:true}")
	protected String isProjectEnable;
	
	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
			throws Exception {
		
		if (!"true".equals(isProjectEnable)) {
			//如果project没有配置，就跳过为不处理
			return super.preHandle(request, response, handler);
		}
		
		
		Project project = null;
		String projectId = null;
		try {
			projectId = (String) request.getSession().getAttribute("projectId");
			project = (Project) request.getSession().getAttribute("project");
			
		} catch (Exception e) {
			logger.error("projectId 检查异常：", e);
			request.getSession().removeAttribute("projectId");
			request.getSession().removeAttribute("project");
		}
		
		if (projectId != null) {
			if (project == null) {
				project = this.projectService.queryObjById(projectId);
				request.getSession().setAttribute("project", project);
			}
			ProjectUtils.setInThreadLocal(project);
			return super.preHandle(request, response, handler);
		}
		
		String serverName = request.getServerName();
		String requestUri = request.getRequestURI();
		
		project = this.projectService.queryByRequest(serverName, requestUri);
		if (project == null) {
			logger.warn("projectId 为空，根据域名检查不到project：[{0}]",serverName);
			
		}else {
			logger.debug("根据域名检查成功 ["+project.getId()+"], projectName :["+project.getProjectName()+"],sessionid" +request.getSession().getId());
		}
		
		if(project != null){
			request.getSession().setAttribute("projectId", project.getId());
			request.getSession().setAttribute("project", project);
			ProjectUtils.setInThreadLocal(project);
		}
		
		return super.preHandle(request, response, handler);
	}
	
}
