package com.els.base.core.service.user;

import java.util.List;

import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.service.BaseService;

/**
 * Created by libing on 2014-06-02  09:02.
 */
public interface UserService extends BaseService<User, UserExample, String> {

    /**
     * 功能：批量插入用户基本信息
     *
     * 注意：
     * 1、会校验必填信息，默认为启用
     * 2、账号，邮箱，手机号码必填一个
     * 3、不插入权限，角色信息，需要进行手动分配
     * @param usersList
     */
    void addUser(List<User> usersList) throws Exception;


    /**
     * 添加用户的时候是否抛出事件，不设置默认为true
     * @param user
     * @param isPublishEvent
     */
    void addObj(User user,Boolean isPublishEvent);

	/**
	 * 修改密码
	 * @param userId
	 * @param oldPwd
	 * @param newPwd
	 * @throws Exception
	 */
    void modifyPwd(String userId, String oldPwd, String newPwd) throws Exception;

    /**
     * 查询所有被禁用的帐号
     * @return
     */
    public List<User> queryAllUserIsDisabled();

    /**
     * 根据登录帐号查找用户
     * @param userLoginName
     * @return
     */
    User findByUserLoginName(String userLoginName);
    
    /**
     * 禁用帐号
     * @param userId
     * @param status
     */
    void disableMembers(String userId, Integer status);
    
    /**
     * 重置密码
     * @param password
     * @return
     * @throws Exception 
     */
	void resetPwd(String password, String userId) throws Exception;

    /**
     * 修改密码
     * @param password
     * @param userId
     */
    public void updatePwd(String password, String userId)throws Exception;

	/**
	 * 校验密码是否正确
	 * @param oldPwd
	 * @return
	 */
	boolean checkPassword(String userId, String oldPwd);

    /**
     * 启用、禁用用户
     * @param userId
     */
    void disableUserById(String userId);
    
    /**
     * 查询用户是否已存在
     * @param user
     * @return
     */
    boolean findUserIsExist(User user);
    
    /**
     * 删除用户数据
     */
    void deleteUserInfo(UserExample example);

    /**
     * 为MDM系统导入的供应商添加用户
     * @param user
     */
	void addUserFromMdm(User user);

}
