package com.els.base.core.service.dictionary;

import java.util.List;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;

public interface DicGroupItemService  {

    public List<DicGroupItem> queryItemsByGroupCode(String dicGroupCode);

    public DicGroupItem queryItems(String dicGroupCode, String dicGroupItemCode);

    public DicGroupItem queryItemByValue(String dicGroupCode, String dicGroupItemValue);

    public void deleteItemsByGroupId(String dicGroupId);

    /**
     * 添加
     * 
     * @param t
     */
    public void addObj(DicGroupItem t);

    /**
     * 根据id删除
     * 
     * @param id
     */
    public void deleteObjById(String id);

    /**
     * 修改，实体中必须带有id
     * 
     * @param t
     */
    public void modifyObj(DicGroupItem t);

    /**
     * 根据id查询
     * 
     * @param id
     * @return
     */
    public DicGroupItem queryObjById(String id);

    /**
     * 根据查询条件查询所有
     * 
     * @param example
     * @return
     */
    public List<DicGroupItem> queryAllObjByExample(DicGroupItemExample example);

    /**
     * 根据查询条件分页查询
     * 
     * @param example
     * @return
     */
    public PageView<DicGroupItem> queryObjByPage(DicGroupItemExample example);
}
