/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.service.project.impl;

import com.els.base.core.dao.project.ProjectMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.service.project.ProjectService;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="projectService")
public class ProjectServiceImpl
implements ProjectService {
    private Logger logger = LoggerFactory.getLogger(ProjectServiceImpl.class);
    private static Pattern pattern = Pattern.compile("http:\\/\\/([\\w\\.]+)(:(\\d+))*(\\/(\\w+)*)?");
    @Resource
    protected ProjectMapper projectMapper;

    @CacheEvict(value={"project"}, allEntries=true)
    public void addObj(Project t) {
        this.projectMapper.insertSelective(t);
    }

    @CacheEvict(value={"project"}, allEntries=true)
    public void deleteObjById(String id) {
        this.projectMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"project"}, allEntries=true)
    public void modifyObj(Project t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.projectMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"project"}, keyGenerator="redisKeyGenerator")
    public Project queryObjById(String id) {
        return this.projectMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"project"}, keyGenerator="redisKeyGenerator")
    public List<Project> queryAllObjByExample(ProjectExample example) {
        return this.projectMapper.selectByExample(example);
    }

    @Cacheable(value={"project"}, keyGenerator="redisKeyGenerator")
    public PageView<Project> queryObjByPage(ProjectExample example) {
        PageView<Project> pageView = example.getPageView();
        pageView.setQueryResult(this.projectMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"project"}, keyGenerator="redisKeyGenerator")
    public Project queryByRequest(String serverName, String requestUri) {
        ProjectExample projectExample = new ProjectExample();
        String domainLike = serverName + "%";
        projectExample.createCriteria().andProjectDomainLike(domainLike);
        projectExample.or().andProjectDomainLike("%http://" + domainLike);
        projectExample.or().andProjectDomainLike("%https://" + domainLike);
        projectExample.setOrderByClause("project_domain desc, create_time asc");
        List<Project> projectList = this.queryAllObjByExample(projectExample);
        if (CollectionUtils.isEmpty(projectList)) {
            return null;
        }
        Project project = null;
        for (int i = 0; i < projectList.size(); ++i) {
            String domainConfig = projectList.get(i).getProjectDomain();
            String[] domainArray = domainConfig.split(";");
            boolean isMatch = false;
            for (int j = 0; domainArray != null && j < domainArray.length; ++j) {
                isMatch = this.isMatch(serverName, requestUri, domainArray[j]);
                if (!isMatch) continue;
                project = projectList.get(i);
                String projectName = project == null ? null : project.getProjectName();
                this.logger.debug("request:" + serverName + "/" + requestUri + ", match project name :" + projectName);
                return project;
            }
        }
        return project;
    }

    private boolean isMatch(String serverName, String requestUri, String projectConfigUrl) {
        Matcher matcher = pattern.matcher(projectConfigUrl);
        if (!matcher.find()) {
            return false;
        }
        String domainInConfig = matcher.group(1);
        String appNameInConfig = matcher.group(5);
        String appName = this.geteAppNameFromUri(requestUri);
        if (StringUtils.isNotBlank((String)appNameInConfig) && !appNameInConfig.equals(appName)) {
            return false;
        }
        return domainInConfig.equals(serverName);
    }

    private String geteAppNameFromUri(String requestUri) {
        String appName = null;
        int endIndex = requestUri.indexOf("/", 1);
        appName = endIndex < 0 ? requestUri : requestUri.substring(1, endIndex);
        return appName;
    }
}

