package com.els.base.core.utils.project;

import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;

/**
 * 项目信息工具，根据请求中的域名信息获取项目信息。
 * <p/>
 * 警告:请不要在service陈中使用。因为是要通过controller层的interceptor获取的，service获取不了。
 * 
 * @author hzy
 *
 */
public class ProjectUtils {

    public static final ThreadLocal<Project> threadLocal = new ThreadLocal<>();

    public static void setInThreadLocal(Project project) {
        threadLocal.set(project);
    }

    public static Project getProject() {
        Project project = threadLocal.get();
        if (project == null) {
            throw new CommonException("当前操作无法匹配到对应的系统,(Can not match project's id)","unable_system");
        }
        return project;
    }
    
    public static String getProjectId() {
        Project project = getProject();
        if (project == null) {
            return null;
        }
        return project.getId();
    }
    
    public static String getCompanyId(){
    	Project project=getProject();
    	if(project == null){
    		return null;
    	}
    	return project.getCompanyId();
    }

}
