package com.els.base.core.service.dictionary;

import java.util.List;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;

public interface DicGroupService {
    /**
     * 添加
     * 
     * @param t
     */
    public void addObj(DicGroup t);

    /**
     * 根据id删除
     * 
     * @param id
     */
    public void deleteObjById(String id);

    /**
     * 修改，实体中必须带有id
     * 
     * @param t
     */
    public void modifyObj(DicGroup t);

    /**
     * 根据id查询
     * 
     * @param id
     * @return
     */
    public DicGroup queryObjById(String id);

    /**
     * 根据查询条件查询所有
     * 
     * @param example
     * @return
     */
    public List<DicGroup> queryAllObjByExample(DicGroupExample example);

    /**
     * 根据查询条件分页查询
     * 
     * @param example
     * @return
     */
    public PageView<DicGroup> queryObjByPage(DicGroupExample example);
}
