package com.els.base.core.utils.dictonary;

import java.util.List;

import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.utils.SpringContextHolder;

/**
 * 数据字典工具
 * @author hzy
 *
 */
public class DicUtils {

	public static DicGroupItem getDicGroupItemByCode(String dicGroupCode, String dicGroupItemCode){
		DicGroupItemService service = SpringContextHolder.getOneBean(DicGroupItemService.class);
		return service.queryItems(dicGroupCode, dicGroupItemCode);
	}
	
	public static DicGroupItem getDicGroupItemByValue(String dicGroupCode, String dicGroupItemValue){
		DicGroupItemService service = SpringContextHolder.getOneBean(DicGroupItemService.class);
		return service.queryItemByValue(dicGroupCode, dicGroupItemValue);
	}
	
	public static List<DicGroupItem> getDicGroupItemsByGroupCode(String dicGroupCode){
		DicGroupItemService service = SpringContextHolder.getOneBean(DicGroupItemService.class);
		return service.queryItemsByGroupCode(dicGroupCode);
	}
}
