package com.els.base.core.web.controller.user;

import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * Created by libing on 2014-06-02 08:57.
 */
@Api("登录帐号管理")
@Controller
@RequestMapping("user")
public class UserController {

	@Autowired
	private UserService userService;
	
	@ApiOperation(value = "根据id查询帐号资料", httpMethod="GET")
	@RequestMapping("service/queryUserDetail")
	@ResponseBody
	public ResponseResult<User> queryUserDetail(@ApiParam(value="用户ID")String userId) {
		User user = userService.queryObjById(userId);
		return ResponseResult.success(user);
	}

/*	@ApiOperation(value="添加帐号", httpMethod="POST")
	@RequestMapping("service/addUser")
	@ResponseBody
	public ResponseResult<String> addUser(@RequestBody User user) {
		user.setId(null);
		user.setIsEnable(Constant.YES_INT);
		user.setProjectCode(ProjectUtils.getProject().getProjectCode());
		userService.addObj(user);
		return ResponseResult.success();
	}
*/
	@ApiOperation(value="根据id禁用帐号", httpMethod="GET")
	@RequestMapping("service/disableUser")
	@ResponseBody
	public ResponseResult<String> disableUser(@ApiParam(value="用户ID")String userId) {
		userService.disableUserById(userId);
		return ResponseResult.success();
	}

	@ApiOperation(value="修改帐号信息(不修改密码)", httpMethod="POST")
	@RequestMapping("service/modifyUser")
	@ResponseBody
	public ResponseResult<String> modifyUser(@RequestBody User user, HttpSession session) {
		user.setPassword(null); // 不修改密码
		userService.modifyObj(user);
		return ResponseResult.success();
	}

	@ApiOperation(value="查询所有帐号", httpMethod="GET")
	@RequestMapping("service/findByPage")
	@ResponseBody
	public ResponseResult<PageView<User>> findByPage(
    		@ApiParam(value="所在页",defaultValue="1" ) @RequestParam(defaultValue="1") int pageNo, 
    		@ApiParam(value="每页数量", defaultValue="10") @RequestParam(defaultValue="10")  int pageSize,
    		@ApiParam(value="查询条件") @RequestBody(required=false) List<QueryParam> queryParams) {
		UserExample example = new UserExample();
		example.setPageView(new PageView<User>(pageNo, pageSize));
		example.setOrderByClause("create_time DESC");
		if (CollectionUtils.isNotEmpty(queryParams)) {
			CriteriaUtils.addCriterion(example.createCriteria(), queryParams);
		}
		
		PageView<User> list = userService.queryObjByPage(example);
		return ResponseResult.success(list);
	}

	/**
	 * 修改密码--验证旧密码是否输入正确
	 *
	 * @author tissue
	 */
	@ApiOperation(value="检查旧密码是否正确,返回1正确，0不正确", httpMethod="GET")
	@ResponseBody
	@RequestMapping("service/checkOldPwd")
	public ResponseResult<Integer> checkOldPwd(String userId, String oldPwd) {
		int result = userService.checkPassword(userId, oldPwd) ? 1: 0;
		return ResponseResult.success(result);
	}
	
	
	@ApiOperation(value="密码重设为123456", httpMethod="GET")
	@ResponseBody
	@RequestMapping("service/resetPwd")
	public ResponseResult<String> resetPwd(@ApiParam(value="用户ID")@RequestParam(required=true)String userId) 
			throws Exception{
		if(StringUtils.isBlank(userId)){
			throw new CommonException("用户ID为空","isNull","用户ID");
		}
		userService.resetPwd(User.DEFAULT_PASSWORD, userId);
		return ResponseResult.success();
	}

	/**
	 * 请求查询账户名
	 * @author Tony
	 */
	@ApiOperation(value="根据用户名，查询账户", httpMethod="GET")
	@RequestMapping("service/queryUserByLoginName")
	@ResponseBody
	public ResponseResult<User> queryUserByLoginName(String loginName) {
		return ResponseResult.success(userService.findByUserLoginName(loginName));
	}

}
