package com.els.base.core.dao.user.handler;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.collections.MapUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

import com.els.base.core.service.user.UserExtInfoQueryService;
import com.els.base.utils.SpringContextHolder;

public class UserExtInfoTypeHandler implements TypeHandler<Map<String, Serializable>> {

	@Override
	public void setParameter(PreparedStatement ps, int i, Map<String, Serializable> parameter, JdbcType jdbcType)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public Map<String, Serializable> getResult(ResultSet rs, String columnName) throws SQLException {
		String userId = rs.getString(columnName);
		return this.loadUserExtInfo(userId);
	}

	@Override
	public Map<String, Serializable> getResult(ResultSet rs, int columnIndex) throws SQLException {
		String userId = rs.getString(columnIndex);
		return this.loadUserExtInfo(userId);
	}

	@Override
	public Map<String, Serializable> getResult(CallableStatement cs, int columnIndex) throws SQLException {
		String userId = cs.getString(columnIndex);
		return this.loadUserExtInfo(userId);
	}

	/**
	 * 加载会员拓展消息
	 * 
	 * @param userId
	 * @return
	 */
	private Map<String, Serializable> loadUserExtInfo(String userId) {
		Map<String, UserExtInfoQueryService> loaderList = SpringContextHolder.getBeans(UserExtInfoQueryService.class);
		if (MapUtils.isEmpty(loaderList)) {
			return null;
		}
		
		Map<String, Serializable> extInfo = new HashMap<>(); //用户的拓展信息
		Map<String, String> keyAndServiceName = new HashMap<>(); //key与service的map

		Iterator<Entry<String, UserExtInfoQueryService>> iterator = loaderList.entrySet().iterator();

		while (iterator.hasNext()) {
			// 遍历查询出所有的拓展消息的查询service
			UserExtInfoQueryService loader = iterator.next().getValue();

			// 查询出key
			String key = loader.getExtKey();
			if (extInfo.containsKey(key)) {
				throw new RuntimeException("加载用户拓展信息时，key冲突。key[" + key + "]出现在[" + keyAndServiceName.get(key) + "],["
						+ loader.getClass() + "]");
			}

			// 查询出数据
			Serializable memberExtInfo = loader.getData(userId);

			keyAndServiceName.put(key, loader.getClass().toString());
			extInfo.put(key, memberExtInfo);
		}

		return extInfo;
	}
}
