package com.els.base.core.service.dictionary.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.dao.dictionary.DicGroupMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;

@Service("dicGroupService")
public class DicGroupServiceImpl implements DicGroupService {
	
	@Resource
	protected DicGroupMapper dicGroupMapper;
	
	@Resource
	protected DicGroupItemService dicGroupItemService;

	@CacheEvict(value={"dicGroup"}, allEntries=true)
	@Override
	public void addObj(DicGroup t) {
		if (StringUtils.isBlank(t.getCode())) {
			throw new CommonException("code值不能为空", "base_canot_be_null","code值");
		}
		
		DicGroupExample example = new DicGroupExample();
		example.createCriteria().andCodeEqualTo(t.getCode());
		if (this.dicGroupMapper.countByExample(example) >0 ) {
			throw new CommonException("code值已存在", "base_is_exists","code值");
		}
		if(t.getCode().length()>100 || t.getName().length()>100){
                    throw new CommonException("编码或名称长度不能超过100","length_canot_exceed", "编码或名称","100");
                }
		this.dicGroupMapper.insertSelective(t);
	}

	@CacheEvict(value={"dicGroup"}, allEntries=true)
	@Transactional
	@Override
	public void deleteObjById(String id) {
		this.dicGroupMapper.deleteByPrimaryKey(id);
		this.dicGroupItemService.deleteItemsByGroupId(id);
	}

	@CacheEvict(value={"dicGroup"}, allEntries=true)
	@Override
	public void modifyObj(DicGroup t) {
		if(t==null || t.getId() == null ){
			throw new CommonException("id 不能为空", "id_is_blank");
		}
		
		if (StringUtils.isNotBlank(t.getCode())) {
			if(t.getCode().length()>100 || t.getName().length()>100){
	                    throw new CommonException("编码或名称长度不能超过100", "length_canot_exceed", "编码或名称","100");
			}
		}
		this.dicGroupMapper.updateByPrimaryKeySelective(t);
	}

	@Cacheable(value="dicGroup", keyGenerator="redisKeyGenerator")
	@Override
	public DicGroup queryObjById(String id) {
		return this.dicGroupMapper.selectByPrimaryKey(id);
	}

	@Cacheable(value="dicGroup", keyGenerator="redisKeyGenerator")
	@Override
	public List<DicGroup> queryAllObjByExample(DicGroupExample example) {
		return this.dicGroupMapper.selectByExample(example);
	}

	@Cacheable(value="dicGroup", keyGenerator="redisKeyGenerator")
	@Override
	public PageView<DicGroup> queryObjByPage(DicGroupExample example) {
		PageView<DicGroup> pageView = example.getPageView();
		pageView.setQueryResult(this.dicGroupMapper.selectByExampleByPage(example));
		return pageView;
	}

}
