/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.service.dictionary.impl;

import com.els.base.core.dao.dictionary.DicGroupItemMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="dicGroupItemService")
public class DicGroupItemServiceImpl
implements DicGroupItemService {
    @Resource
    protected DicGroupItemMapper dicGroupItemMapper;
    @Resource
    protected DicGroupService dicGroupService;

    @Override
    @CacheEvict(value={"dicGroupItem"}, allEntries=true)
    public void addObj(DicGroupItem t) {
        if (StringUtils.isBlank((String)t.getCode()) || t.getGroupId() == null) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u53c2\u6570"});
        }
        if (t.getCode().length() > 100 || t.getName().length() > 100) {
            throw new CommonException("\u7f16\u7801\u6216\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", new Object[]{"\u7f16\u7801\u6216\u540d\u79f0", "100"});
        }
        DicGroupItemExample example = new DicGroupItemExample();
        example.createCriteria().andCodeEqualTo(t.getCode()).andGroupIdEqualTo(t.getGroupId());
        if (this.dicGroupItemMapper.countByExample(example) > 0) {
            throw new CommonException("code\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
        }
        this.dicGroupItemMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"dicGroupItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.dicGroupItemMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"dicGroupItem"}, allEntries=true)
    public void deleteItemsByGroupId(String dicGroupId) {
        DicGroupItemExample example = new DicGroupItemExample();
        example.createCriteria().andGroupIdEqualTo(dicGroupId);
        this.dicGroupItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"dicGroupItem"}, allEntries=true)
    public void modifyObj(DicGroupItem t) {
        if (t == null || t.getGroupId() == null || StringUtils.isBlank((String)t.getCode()) || StringUtils.isBlank((String)t.getValue()) || StringUtils.isBlank((String)t.getName())) {
            throw new CommonException("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u586b\u5199\u5fc5\u8981\u7684\u4fe1\u606f", "parameter_incomplete");
        }
        if (!t.getCode().matches("[\\w\\_\\-]+")) {
            throw new CommonException("\u7f16\u7801\u7684\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", new Object[]{"\u7f16\u7801"});
        }
        if (t.getCode().length() > 100 || t.getName().length() > 100) {
            throw new CommonException("\u7f16\u7801\u6216\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", new Object[]{"\u7f16\u7801\u6216\u540d\u79f0", "100"});
        }
        this.dicGroupItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"dicGroupItem"}, keyGenerator="redisKeyGenerator")
    public DicGroupItem queryObjById(String id) {
        return this.dicGroupItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"dicGroupItem"}, keyGenerator="redisKeyGenerator")
    public List<DicGroupItem> queryAllObjByExample(DicGroupItemExample example) {
        return this.dicGroupItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"dicGroupItem"}, keyGenerator="redisKeyGenerator")
    public PageView<DicGroupItem> queryObjByPage(DicGroupItemExample example) {
        PageView<DicGroupItem> pageView = example.getPageView();
        pageView.setQueryResult(this.dicGroupItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"dicGroupItem"}, keyGenerator="redisKeyGenerator")
    public List<DicGroupItem> queryItemsByGroupCode(String dicGroupCode) {
        DicGroupExample dicGroupExample = new DicGroupExample();
        dicGroupExample.createCriteria().andCodeEqualTo(dicGroupCode);
        List<DicGroup> groupList = this.dicGroupService.queryAllObjByExample(dicGroupExample);
        if (CollectionUtils.isEmpty(groupList)) {
            return null;
        }
        if (groupList.size() > 1) {
            throw new RuntimeException("\u6570\u636e\u5f02\u5e38\uff0cdicGroupCode\u4e0b,\u6570\u636e\u591a\u4f59\u4e00\u6761");
        }
        DicGroup dicGroup = groupList.get(0);
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdEqualTo(dicGroup.getId());
        dicGroupExample.setOrderByClause("name ASC");
        return this.queryAllObjByExample(dicGroupItemExample);
    }

    @Override
    @Cacheable(value={"dicGroupItem"}, keyGenerator="redisKeyGenerator")
    public DicGroupItem queryItems(String dicGroupCode, String dicGroupItemCode) {
        if (StringUtils.isBlank((String)dicGroupCode) || StringUtils.isBlank((String)dicGroupItemCode)) {
            throw new NullPointerException("dicGroupCode, dicGroupItemCode\u53c2\u6570\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DicGroupExample dicGroupExample = new DicGroupExample();
        dicGroupExample.createCriteria().andCodeEqualTo(dicGroupCode);
        List<DicGroup> groupList = this.dicGroupService.queryAllObjByExample(dicGroupExample);
        if (CollectionUtils.isEmpty(groupList)) {
            return null;
        }
        if (groupList.size() > 1) {
            throw new RuntimeException("\u6570\u636e\u5f02\u5e38\uff0cdicGroupCode\u4e0b,\u6570\u636e\u591a\u4e8e\u4e00\u6761");
        }
        DicGroup dicGroup = groupList.get(0);
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdEqualTo(dicGroup.getId()).andCodeEqualTo(dicGroupItemCode);
        dicGroupExample.setOrderByClause("name ASC");
        List<DicGroupItem> dicGroupItemList = this.dicGroupItemMapper.selectByExample(dicGroupItemExample);
        if (CollectionUtils.isEmpty(dicGroupItemList)) {
            return null;
        }
        if (dicGroupItemList.size() > 1) {
            throw new RuntimeException("\u6570\u636e\u5f02\u5e38\uff0cdicGroupCode dicGroupItemCode \u4e0b,\u6570\u636e\u591a\u4e8e\u4e00\u6761");
        }
        return dicGroupItemList.get(0);
    }

    @Override
    public DicGroupItem queryItemByValue(String dicGroupCode, String dicGroupItemValue) {
        if (StringUtils.isBlank((String)dicGroupCode) || StringUtils.isBlank((String)dicGroupItemValue)) {
            throw new NullPointerException("dicGroupCode, dicGroupItemValue\u53c2\u6570\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DicGroupItem> list = this.queryItemsByGroupCode(dicGroupCode);
        for (int i = 0; i < list.size(); ++i) {
            DicGroupItem dicGroupItem = list.get(i);
            if (!dicGroupItem.getValue().equals(dicGroupItemValue)) continue;
            return dicGroupItem;
        }
        return null;
    }
}

