/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.service.demo.impl;

import com.els.base.core.dao.demo.DemoMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.demo.Demo;
import com.els.base.core.entity.demo.DemoExample;
import com.els.base.core.service.demo.DemoService;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDemoService")
public class DemoServiceImpl
implements DemoService {
    @Resource
    protected DemoMapper demoMapper;

    @CacheEvict(value={"demo"}, allEntries=true)
    public void addObj(Demo t) {
        this.demoMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"demo"}, allEntries=true)
    public void addAll(List<Demo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.demoMapper.insertBatch(list);
    }

    @CacheEvict(value={"demo"}, allEntries=true)
    public void deleteObjById(String id) {
        this.demoMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"demo"}, allEntries=true)
    public void deleteByExample(DemoExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.demoMapper.deleteByExample(example);
    }

    @CacheEvict(value={"demo"}, allEntries=true)
    public void modifyObj(Demo t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.demoMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"demo"}, keyGenerator="redisKeyGenerator")
    public Demo queryObjById(String id) {
        return this.demoMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"demo"}, keyGenerator="redisKeyGenerator")
    public List<Demo> queryAllObjByExample(DemoExample example) {
        return this.demoMapper.selectByExample(example);
    }

    @Cacheable(value={"demo"}, keyGenerator="redisKeyGenerator")
    public PageView<Demo> queryObjByPage(DemoExample example) {
        PageView<Demo> pageView = example.getPageView();
        pageView.setQueryResult(this.demoMapper.selectByExampleByPage(example));
        return pageView;
    }
}

