CREATE TABLE `T_BASE_DEMO`
(
    `ID`          varchar(32) NOT NULL COMMENT '主键',
    `NAME`        varchar(255)     DEFAULT NULL COMMENT '名称',
    `CODE`        varchar(255)     DEFAULT NULL COMMENT '编码',
    `SORT_NO`     int(11)          DEFAULT NULL COMMENT '排序号',
    `CREATE_TIME` timestamp   NULL DEFAULT NULL COMMENT '创建时间',
    `START_TIME`  timestamp   NULL DEFAULT NULL COMMENT '开始时间',
    `END_TIME`    timestamp   NULL DEFAULT NULL COMMENT '结束时间',
    `PRICE`       decimal(16, 6)   DEFAULT NULL COMMENT '价格，小数点',
    `FILE_DATA`   varchar(255)     DEFAULT NULL COMMENT '文件存储',
    `IMAGE`       varchar(255)     DEFAULT NULL COMMENT '图片预览',
    PRIMARY KEY (`ID`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='DEMO';


CREATE TABLE `T_BASE_DIC_GROUP`
(
    `ID`          varchar(32) NOT NULL COMMENT 'ID',
    `PARENT_ID`   int(11)      DEFAULT NULL COMMENT '父级',
    `NAME`        varchar(100) DEFAULT NULL COMMENT '名称',
    `CODE`        varchar(100) DEFAULT NULL COMMENT '编码',
    `DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '描述',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='数据库字典组';


CREATE TABLE `T_BASE_DIC_GROUP_ITEM`
(
    `CODE`        varchar(100) DEFAULT NULL COMMENT '编码',
    `VALUE`       varchar(255) DEFAULT NULL COMMENT '值',
    `NAME`        varchar(100) DEFAULT NULL COMMENT '名称',
    `DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '描述',
    `ID`          varchar(32) NOT NULL COMMENT 'ID',
    `GROUP_ID`    varchar(32)  DEFAULT NULL COMMENT '上级ID',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='数据库字典组-子级';


CREATE TABLE `T_BASE_PROJECT`
(
    `ID`             varchar(32)  NOT NULL,
    `PROJECT_CODE`   varchar(255)      DEFAULT NULL,
    `PROJECT_NAME`   varchar(255)      DEFAULT NULL,
    `PROJECT_DESC`   varchar(500)      DEFAULT NULL,
    `PROJECT_DOMAIN` varchar(255)      DEFAULT NULL,
    `PROJECT_ROUTE`  varchar(255)      DEFAULT NULL,
    `CREATE_TIME`    timestamp(6) NULL DEFAULT NULL,
    `UPDATE_TIME`    timestamp(6) NULL DEFAULT NULL,
    `IS_DELETE`      int(11)           DEFAULT NULL,
    `COMPANY_ID`     varchar(32)       DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `T_BASE_USER`
(
    `ID`              varchar(32)  NOT NULL,
    `LOGIN_NAME`      varchar(255)      DEFAULT NULL,
    `NICK_NAME`       varchar(255)      DEFAULT NULL,
    `PASSWORD`        varchar(255)      DEFAULT NULL,
    `PASSWORD_KEY`    varchar(255)      DEFAULT NULL,
    `PROJECT_CODE`    varchar(255)      DEFAULT NULL,
    `GENDER`          varchar(2)        DEFAULT NULL,
    `EMAIL`           varchar(255)      DEFAULT NULL,
    `MOBILE_PHONE`    varchar(255)      DEFAULT NULL,
    `WORK_NUM`        varchar(255)      DEFAULT NULL,
    `WECHAT`          varchar(255)      DEFAULT NULL,
    `QQ`              varchar(255)      DEFAULT NULL,
    `FAX`             varchar(255)      DEFAULT NULL,
    `CREATE_TIME`     timestamp(6) NULL DEFAULT NULL,
    `UPDATE_TIME`     timestamp(6) NULL DEFAULT NULL,
    `IS_ENABLE`       int(11)           DEFAULT '1',
    `LAST_LOGIN_TIME` timestamp(6) NULL DEFAULT NULL,
    `EXPIRE_TIME`     timestamp(6) NULL DEFAULT NULL,
    `USER_IMG`        varchar(500)      DEFAULT NULL,
    `NAME_IMG`        varchar(500)      DEFAULT NULL COMMENT '图片签名'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;







































