-- ----------------------------
-- 字典组
-- ----------------------------
-- DROP TABLE "T_BASE_DIC_GROUP";
CREATE TABLE "T_BASE_DIC_GROUP"
(
    "NAME"        NVARCHAR2(100),
    "CODE"        NVARCHAR2(100),
    "DESCRIPTION" NVARCHAR2(255),
    "PARENT_ID"   VARCHAR2(32 BYTE),
    "ID"          VARCHAR2(32 BYTE) NOT NULL
);

COMMENT ON COLUMN "T_BASE_DIC_GROUP"."NAME" IS '名称';
COMMENT ON COLUMN "T_BASE_DIC_GROUP"."CODE" IS '编码';
COMMENT ON COLUMN "T_BASE_DIC_GROUP"."DESCRIPTION" IS '描述';
COMMENT ON COLUMN "T_BASE_DIC_GROUP"."PARENT_ID" IS '父字典组';
COMMENT ON COLUMN "T_BASE_DIC_GROUP"."ID" IS 'ID';
COMMENT ON TABLE "T_BASE_DIC_GROUP" IS '字典组';

ALTER TABLE "T_BASE_DIC_GROUP"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 字典行
-- ----------------------------
-- DROP TABLE "T_BASE_DIC_GROUP_ITEM";
CREATE TABLE "T_BASE_DIC_GROUP_ITEM"
(
    "CODE"        NVARCHAR2(100),
    "VALUE"       NVARCHAR2(255),
    "NAME"        NVARCHAR2(100),
    "DESCRIPTION" NVARCHAR2(255),
    "ID"          VARCHAR2(32 BYTE) NOT NULL,
    "GROUP_ID"    VARCHAR2(32 BYTE)
);

COMMENT ON COLUMN "T_BASE_DIC_GROUP_ITEM"."CODE" IS '编码';
COMMENT ON COLUMN "T_BASE_DIC_GROUP_ITEM"."VALUE" IS '代表的值';
COMMENT ON COLUMN "T_BASE_DIC_GROUP_ITEM"."NAME" IS '显示名称';
COMMENT ON COLUMN "T_BASE_DIC_GROUP_ITEM"."DESCRIPTION" IS '描述';
COMMENT ON COLUMN "T_BASE_DIC_GROUP_ITEM"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_DIC_GROUP_ITEM"."GROUP_ID" IS '组ID';

COMMENT ON TABLE "T_BASE_DIC_GROUP_ITEM" IS '字典行';


ALTER TABLE "T_BASE_DIC_GROUP_ITEM"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 项目
-- ----------------------------
-- DROP TABLE "T_BASE_PROJECT";
CREATE TABLE "T_BASE_PROJECT"
(
    "ID"             NVARCHAR2(32) NOT NULL,
    "PROJECT_CODE"   NVARCHAR2(255),
    "PROJECT_NAME"   NVARCHAR2(255),
    "PROJECT_DESC"   NVARCHAR2(500),
    "PROJECT_DOMAIN" NVARCHAR2(255),
    "PROJECT_ROUTE"  NVARCHAR2(255),
    "CREATE_TIME"    DATE DEFAULT sysdate,
    "UPDATE_TIME"    DATE DEFAULT sysdate,
    "IS_DELETE"      NUMBER(11),
    "COMPANY_ID"     VARCHAR2(32 BYTE)
);

COMMENT ON COLUMN "T_BASE_PROJECT"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_CODE" IS '项目编码';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_NAME" IS '项目名称';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_DESC" IS '项目简介';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_DOMAIN" IS '项目域名';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_ROUTE" IS '项目路由';
COMMENT ON COLUMN "T_BASE_PROJECT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_PROJECT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_PROJECT"."IS_DELETE" IS '是否已删除：0否，1是';
COMMENT ON COLUMN "T_BASE_PROJECT"."COMPANY_ID" IS '采购公司ID';
COMMENT ON TABLE "T_BASE_PROJECT" IS '项目';


ALTER TABLE "T_BASE_PROJECT"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 用户表
-- ----------------------------
-- DROP TABLE "T_BASE_USER";
CREATE TABLE "T_BASE_USER"
(
    "ID"              NVARCHAR2(32) NOT NULL,
    "LOGIN_NAME"      NVARCHAR2(255),
    "NICK_NAME"       NVARCHAR2(255),
    "PASSWORD"        NVARCHAR2(255),
    "PASSWORD_KEY"    NVARCHAR2(255),
    "PROJECT_CODE"    NVARCHAR2(255),
    "GENDER"          NVARCHAR2(2),
    "EMAIL"           NVARCHAR2(255),
    "MOBILE_PHONE"    NVARCHAR2(255),
    "WORK_NUM"        NVARCHAR2(255),
    "WECHAT"          NVARCHAR2(255),
    "QQ"              NVARCHAR2(255),
    "FAX"             NVARCHAR2(255),
    "CREATE_TIME"     DATE       DEFAULT sysdate,
    "UPDATE_TIME"     DATE       DEFAULT sysdate,
    "IS_ENABLE"       NUMBER(11) DEFAULT '',
    "LAST_LOGIN_TIME" DATE,
    "EXPIRE_TIME"     DATE,
    "USER_IMG"        NVARCHAR2(500),
    "NAME_IMG"        NVARCHAR2(500)
);
COMMENT ON COLUMN "T_BASE_USER"."LOGIN_NAME" IS '登录名';
COMMENT ON COLUMN "T_BASE_USER"."NICK_NAME" IS '昵称';
COMMENT ON COLUMN "T_BASE_USER"."PASSWORD" IS '密码';
COMMENT ON COLUMN "T_BASE_USER"."PASSWORD_KEY" IS '盐加密密钥';
COMMENT ON COLUMN "T_BASE_USER"."PROJECT_CODE" IS '项目编码';
COMMENT ON COLUMN "T_BASE_USER"."GENDER" IS '性别';
COMMENT ON COLUMN "T_BASE_USER"."EMAIL" IS '邮箱';
COMMENT ON COLUMN "T_BASE_USER"."MOBILE_PHONE" IS '手机号码';
COMMENT ON COLUMN "T_BASE_USER"."WORK_NUM" IS '工号';
COMMENT ON COLUMN "T_BASE_USER"."WECHAT" IS '微信号';
COMMENT ON COLUMN "T_BASE_USER"."QQ" IS 'QQ号';
COMMENT ON COLUMN "T_BASE_USER"."FAX" IS '传真';
COMMENT ON COLUMN "T_BASE_USER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_USER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_USER"."IS_ENABLE" IS '是否禁用 1启用 0禁用';
COMMENT ON COLUMN "T_BASE_USER"."USER_IMG" IS '头像';
COMMENT ON COLUMN "T_BASE_USER"."NAME_IMG" IS '图片签名';
COMMENT ON TABLE "T_BASE_USER" IS '用户表';

ALTER TABLE "T_BASE_USER"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- DEMO
-- ----------------------------
-- DROP TABLE "T_BASE_DEMO";
CREATE TABLE "T_BASE_DEMO"
(
    "ID"          VARCHAR2(32 BYTE) NOT NULL,
    "NAME"        VARCHAR2(255 BYTE),
    "CODE"        VARCHAR2(255 BYTE),
    "SORT_NO"     NUMBER(10),
    "CREATE_TIME" DATE,
    "START_TIME"  DATE,
    "END_TIME"    DATE,
    "PRICE"       NUMBER(16, 6),
    "FILE_DATA"   VARCHAR2(255 BYTE),
    "IMAGE"       VARCHAR2(255 BYTE)
);
COMMENT ON COLUMN "T_BASE_DEMO"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_DEMO"."NAME" IS '名称';
COMMENT ON COLUMN "T_BASE_DEMO"."CODE" IS '编码';
COMMENT ON COLUMN "T_BASE_DEMO"."SORT_NO" IS '排序号';
COMMENT ON COLUMN "T_BASE_DEMO"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_DEMO"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "T_BASE_DEMO"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "T_BASE_DEMO"."PRICE" IS '价格，小数点';
COMMENT ON COLUMN "T_BASE_DEMO"."FILE_DATA" IS '文件存储';
COMMENT ON COLUMN "T_BASE_DEMO"."IMAGE" IS '图片预览';
COMMENT ON TABLE "T_BASE_DEMO" IS 'DEMO';


ALTER TABLE "T_BASE_DEMO"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 项目
-- ----------------------------
-- DROP TABLE "T_BASE_PROJECT";
CREATE TABLE "T_BASE_PROJECT"
(
    "ID"             NVARCHAR2(32) NOT NULL,
    "PROJECT_CODE"   NVARCHAR2(255),
    "PROJECT_NAME"   NVARCHAR2(255),
    "PROJECT_DESC"   NVARCHAR2(500),
    "PROJECT_DOMAIN" NVARCHAR2(255),
    "PROJECT_ROUTE"  NVARCHAR2(255),
    "CREATE_TIME"    DATE DEFAULT sysdate,
    "UPDATE_TIME"    DATE DEFAULT sysdate,
    "IS_DELETE"      NUMBER(11),
    "COMPANY_ID"     VARCHAR2(32 BYTE)
);
COMMENT ON COLUMN "T_BASE_PROJECT"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_CODE" IS '项目编码';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_NAME" IS '项目名称';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_DESC" IS '项目简介';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_DOMAIN" IS '项目域名';
COMMENT ON COLUMN "T_BASE_PROJECT"."PROJECT_ROUTE" IS '项目路由';
COMMENT ON COLUMN "T_BASE_PROJECT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_PROJECT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_PROJECT"."IS_DELETE" IS '是否已删除：0否，1是';
COMMENT ON COLUMN "T_BASE_PROJECT"."COMPANY_ID" IS '采购公司ID';
COMMENT ON TABLE "T_BASE_PROJECT" IS '项目';

