
CREATE TABLE T_BASE_MOULD_NOTICE (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"MOULD_NOTICE_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"MOULD_NOTICE_BILL_TYPE" NUMBER(7) NULL ,
"COMPONENT_TYPE" VARCHAR2(255 BYTE) NULL ,
"COMPONENT_TYPE_DESC" VARCHAR2(255 BYTE) NULL ,
"RELATED_MODEL" VARCHAR2(255 BYTE) NULL ,
"SAFETY_ENVI_PRO_INFLUENCE" VARCHAR2(255 BYTE) NULL ,
"PROJECT_NUMBER" VARCHAR2(255 BYTE) NULL ,
"ABOUT" VARCHAR2(1000 BYTE) NULL ,
"CREATE_BILL_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_REMARK" VARCHAR2(1000 BYTE) NULL ,
"SUP_REMARK" VARCHAR2(1000 BYTE) NULL ,
"SEND_STATUS" NUMBER(7) DEFAULT 0  NULL ,
"SEND_TIME" DATE NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
"CONFIRM_TIME" DATE NULL ,
"CONFIRM_STATUS" NUMBER(7) DEFAULT 0  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL 
)
;
COMMENT ON TABLE T_BASE_MOULD_NOTICE IS '资产管理-开模变更通知单';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."MOULD_NOTICE_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."MOULD_NOTICE_BILL_TYPE" IS '单据类型(0=开模,1=改模)';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."COMPONENT_TYPE" IS '部品类型';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."COMPONENT_TYPE_DESC" IS '部品类型描述';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."RELATED_MODEL" IS '相关机型';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SAFETY_ENVI_PRO_INFLUENCE" IS '安规及环保影响';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PROJECT_NUMBER" IS '项目编号';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."ABOUT" IS '关于';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."CREATE_BILL_USER_NAME" IS '制单人';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PUR_USER_ID" IS '消息推送(采购方用户id)';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SUP_USER_ID" IS '消息推送(供应商方用户id)';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."PUR_REMARK" IS '采购商备注';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."CONFIRM_STATUS" IS '单据确认状态(未确认=0,已确认=1)';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE."UPDATE_TIME" IS '修改时间';

ALTER TABLE T_BASE_MOULD_NOTICE ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_MOULD_NOTICE ADD PRIMARY KEY ("ID");
