
CREATE TABLE T_BASE_MOULD_NOTICE_MATERIAL (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"MOULD_NOTICE_ID" VARCHAR2(32 BYTE) NULL ,
"NOTICE_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"ENGLISH_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_SPEC" VARCHAR2(255 BYTE) NULL ,
"SINGLE_UNIT_DOSAGE" VARCHAR2(255 BYTE) NULL ,
"SKETCH_MAP" VARCHAR2(2000 BYTE) NULL ,
"POST_PROCESSING" VARCHAR2(255 BYTE) NULL ,
"PRODUCT_MOULD_QUANTITY" NUMBER(13,2) DEFAULT 0  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_MOULD_NOTICE_MATERIAL IS '资产管理-开模变更通知单-物料信息';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."MOULD_NOTICE_ID" IS '单据id';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."NOTICE_ITEM_ID" IS '变更单的模具信息id';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."ENGLISH_NAME" IS '英文名称';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."MATERIAL_SPEC" IS '规格';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."SINGLE_UNIT_DOSAGE" IS '单台用量';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."SKETCH_MAP" IS '示意图';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."POST_PROCESSING" IS '后加工';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."PRODUCT_MOULD_QUANTITY" IS '出模数';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_MATERIAL."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_MOULD_NOTICE_MATERIAL ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_MOULD_NOTICE_MATERIAL ADD PRIMARY KEY ("ID");
