/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.mould.notice.dao.MouldNoticeMaterialMapper;
import com.els.base.mould.notice.entity.MouldNoticeMaterial;
import com.els.base.mould.notice.entity.MouldNoticeMaterialExample;
import com.els.base.mould.notice.service.MouldNoticeMaterialService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultMouldNoticeMaterialService")
public class MouldNoticeMaterialServiceImpl
implements MouldNoticeMaterialService {
    @Resource
    protected MouldNoticeMaterialMapper mouldNoticeMaterialMapper;

    @Override
    @CacheEvict(value={"mouldNoticeMaterial"}, allEntries=true)
    public void addObj(MouldNoticeMaterial t) {
        this.mouldNoticeMaterialMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"mouldNoticeMaterial"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldNoticeMaterialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mouldNoticeMaterial"}, allEntries=true)
    public void modifyObj(MouldNoticeMaterial t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldNoticeMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"mouldNoticeMaterial"}, keyGenerator="redisKeyGenerator")
    public MouldNoticeMaterial queryObjById(String id) {
        return this.mouldNoticeMaterialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"mouldNoticeMaterial"}, keyGenerator="redisKeyGenerator")
    public List<MouldNoticeMaterial> queryAllObjByExample(MouldNoticeMaterialExample example) {
        return this.mouldNoticeMaterialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"mouldNoticeMaterial"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldNoticeMaterial> queryObjByPage(MouldNoticeMaterialExample example) {
        PageView<MouldNoticeMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldNoticeMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldNoticeMaterial"}, allEntries=true)
    public void deleteByNoticeId(String noticeId) {
        MouldNoticeMaterialExample example = new MouldNoticeMaterialExample();
        example.createCriteria().andMouldNoticeIdEqualTo(noticeId);
        this.mouldNoticeMaterialMapper.deleteByExample(example);
    }
}

