
CREATE TABLE T_BASE_MOULD_ADJUST (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_CHANGE_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_CHANGE_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_CHANGE_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_CHANGE_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_CHANGE_NAME" VARCHAR2(255 BYTE) NULL ,
"ADJUST_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"CHANGE_TYPE" NUMBER(7) NULL ,
"CONTACTS" VARCHAR2(255 BYTE) NULL ,
"ADDRESS" VARCHAR2(255 BYTE) NULL ,
"TELEPHONE" VARCHAR2(255 BYTE) NULL ,
"CREATE_BILL_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_REMARK" VARCHAR2(1000 BYTE) NULL ,
"SUP_REMARK" VARCHAR2(1000 BYTE) NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
"SEND_STATUS" NUMBER(7) DEFAULT 0  NULL ,
"SEND_TIME" DATE NULL ,
"CONFIRM_STATUS" NUMBER(7) DEFAULT 0  NULL ,
"CONFIRM_TIME" DATE NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL 
)

;
COMMENT ON TABLE T_BASE_MOULD_ADJUST IS '资产管理-模具寿命/移模调整单';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_CHANGE_COMPANY_ID" IS '变更后的供应商ID';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_CHANGE_SRM_CODE" IS '变更后的供应商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_CHANGE_SAP_CODE" IS '变更后的供应商SAP编码';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_CHANGE_FULL_NAME" IS '变更后的供应商全称';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_CHANGE_NAME" IS '变更后的供应商简称';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."ADJUST_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."CHANGE_TYPE" IS '变更类型(0=寿命调整,1=移模,2=变更供应商)';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."CONTACTS" IS '联系人';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."ADDRESS" IS '地址';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."TELEPHONE" IS '电话';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."CREATE_BILL_USER_NAME" IS '制单人';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."PUR_REMARK" IS '采购商备注';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."CONFIRM_STATUS" IS '单据确认状态(未确认=0,已确认=1)';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."CREATE_TIME" IS '制单时间';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."PUR_USER_ID" IS '消息推送(采购方用户id)';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST."SUP_USER_ID" IS '消息推送(供应商方用户id)';


ALTER TABLE T_BASE_MOULD_ADJUST ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_MOULD_ADJUST ADD PRIMARY KEY ("ID");
