/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.life.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.mould.life.entity.MouldLife;
import com.els.base.mould.life.entity.MouldLifeExample;
import com.els.base.mould.life.service.MouldLifeSapService;
import com.els.base.mould.life.service.MouldLifeService;
import com.els.base.mould.life.utils.ContentCheckerConverter;
import com.els.base.mould.life.utils.LifeConfirmStatus;
import com.els.base.mould.master.utils.ExcelFileData;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.IContentChecker;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
@Controller
@RequestMapping(value={"mouldLife"})
public class MouldLifeController {
    @Resource
    protected MouldLifeService mouldLifeService;
    @Resource
    protected MouldLifeSapService mouldLifeSapService;

    @ApiOperation(httpMethod="POST", value="\u6536\u8d27\u68c0\u67e5")
    @RequestMapping(value={"service/receiveCheck"})
    @ResponseBody
    public ResponseResult<String> receiveCheck(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        this.mouldLifeSapService.insert(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<MouldLife> data) {
        Assert.isNotEmpty(data, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        for (MouldLife mouldLife : data) {
            if (Constant.YES_INT.equals(mouldLife.getSendStatus())) {
                throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
            }
            Assert.isNotBlank((String)mouldLife.getId(), (String)"id\u4e3a\u7a7a,\u4fdd\u5b58\u5931\u8d25");
            Assert.isNotNull((Object)mouldLife.getMouldUsed(), (String)"\u672c\u671f\u4f7f\u7528\u6a21\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            this.mouldLifeService.modifyMouldLife(mouldLife);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u9001\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
    @RequestMapping(value={"service/sendToPur"})
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        this.mouldLifeService.sendToPur(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u786e\u8ba4\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
    @RequestMapping(value={"service/confirmForPur"})
    @ResponseBody
    public ResponseResult<String> confirmForPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        this.mouldLifeService.confirmForPur(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u9000\u56de\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
    @RequestMapping(value={"service/backForPur"})
    @ResponseBody
    public ResponseResult<String> backForPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        this.mouldLifeService.backForPur(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        MouldLifeExample example = new MouldLifeExample();
        example.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        example.or().andIdIn((List)ids).andConfirmStatusNotEqualTo(LifeConfirmStatus.NO_CONFIRM.getCode());
        List list = this.mouldLifeService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String mouldNoList = list.stream().map(MouldLife::getMouldNo).collect(Collectors.joining(","));
            throw new CommonException(String.format("\u4ee5\u4e0b\u6a21\u5177\u5bff\u547d\u4e0d\u80fd\u5220\u9664\uff0c\u56e0\u4e3a\u6a21\u5177\u5df2\u7ecf\u53d1\u9001\u8fc7\u7ed9\u91c7\u8d2d\u65b9\u3002\u6a21\u5177\u5bff\u547d\uff1a%s", mouldNoList));
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        this.mouldLifeService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u51faExcel\u6a21\u677f", httpMethod="POST")
    @RequestMapping(value={"service/exportToExcel"})
    @ResponseBody
    public void exportToExcel(HttpServletResponse response) throws Exception {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u6a21\u5177\u5bff\u547d\u7ba1\u7406Excel\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"\u6a21\u5177\u5bff\u547d\u7ba1\u7406Excel\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
    }

    private List<TitleAndModelKey> createExcelHeaderColumn() throws WriteException {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setDateFormat("yyyyMMdd");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        WritableCellFormat contentFormate = new WritableCellFormat(new WritableFont(WritableFont.createFont((String)"\u5fae\u8f6f\u96c5\u9ed1"), 10));
        contentFormate.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.BLACK);
        contentFormate.setVerticalAlignment(VerticalAlignment.CENTRE);
        contentFormate.setWrap(false);
        TitleAndModelKey mouldNo = ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7\n(\u6309\u7acb\u767d\u6a21\u5177\u6e05\u5355\u4e0a\u7684\u6a21\u5177\u7f16\u7801\u586b\u5199)", (String)"mouldNo");
        mouldNo.setContentFormat(contentFormate);
        titleAndModelKeys.add(mouldNo);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0\n(\u7edf\u4e00\u6309\u7acb\u767d\u547d\u540d\u7684\u6807\u51c6\u63cf\u8ff0\u586b\u5199)", (String)"mouldDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177ID(\u5fc5\u586b)\n(\u6309\u7acb\u767d\u547d\u540d\u7684\u6a21\u5177ID\u8fdb\u884c\u586b\u5199)", (String)"mouldId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u673a\u578b\n(\u751f\u4ea7\u4ea7\u54c1\u7684\u673a\u53f0\u7c7b\u578b)", (String)"boardDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8154\u6570\n(\u8be5\u5957\u6a21\u5177\u7684\u603b\u8154\u6570)", (String)"cavityQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u672c\u671f\u4f7f\u7528\u6a21\u6b21(\u5fc5\u586b\n(\u5728\u672c\u6b21\u7edf\u8ba1\u671f\u95f4\u8be5\u5957\u6a21\u5177\u4f7f\u7528\u4e86\u591a\u5c11\u6a21\u6b21\u3002\u5355\u4f4d\uff1a\u6b21)", (String)"mouldUsed"));
        TitleAndModelKey usedStartTime = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u7b97\u671f\u95f4\u4ece(\u5fc5\u586b\uff1aYYYYMMDD)", (String)"usedStartTime");
        usedStartTime.setToObjConverter((StrToObjConverter)dateConverter);
        usedStartTime.setToStrConverter((ObjToStrConverter)dateConverter);
        usedStartTime.setContentChecker((IContentChecker)new ContentCheckerConverter());
        titleAndModelKeys.add(usedStartTime);
        TitleAndModelKey usedEndTime = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u7b97\u671f\u95f4\u81f3(\u5fc5\u586b\uff1aYYYYMMDD)", (String)"usedEndTime");
        usedEndTime.setToObjConverter((StrToObjConverter)dateConverter);
        usedEndTime.setToStrConverter((ObjToStrConverter)dateConverter);
        usedEndTime.setContentChecker((IContentChecker)new ContentCheckerConverter());
        titleAndModelKeys.add(usedEndTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165Excel", httpMethod="POST")
    @RequestMapping(value={"service/importFromExcel"})
    @ResponseBody
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request) throws IOException, Exception {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
        User user = SpringSecurityUtils.getLoginUser();
        Company currentCompany = CompanyUtils.currentCompany();
        int i = 0;
        try {
            i = this.mouldLifeService.importExcel(file, titleAndModelKeys, user, currentCompany);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage());
        }
        return ResponseResult.success((Object)("\u6210\u529f\u5bfc\u5165" + i + "\u6761\u8bb0\u5f55!"));
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301xls");
        }
        return file;
    }

    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        MouldLifeExample example = new MouldLifeExample();
        if (CompanyUtils.isSupCompany()) {
            example.setOrderByClause("CREATE_DATE DESC");
        } else {
            example.setOrderByClause("SPARE_FIELD4 DESC");
        }
        MouldLifeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        }
        String currentCompanyId = CompanyUtils.currentCompanyId();
        List mouldLifes = null;
        if (CollectionUtils.isEmpty(ids)) {
            if (CompanyUtils.isSupCompany()) {
                criteria.andConceiveSupCompanyIdEqualTo(currentCompanyId);
            } else {
                criteria.andSendStatusEqualTo(Constant.YES_INT);
            }
            mouldLifes = this.mouldLifeService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)mouldLifes, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            if (CompanyUtils.isSupCompany()) {
                criteria.andConceiveSupCompanyIdEqualTo(currentCompanyId).andIdIn((List)ids);
            } else {
                criteria.andIdIn((List)ids);
            }
            mouldLifes = this.mouldLifeService.queryAllObjByExample((IExample)example);
        }
        for (MouldLife mouldLife : mouldLifes) {
            if (mouldLife.getMouldStatus() == 0) {
                mouldLife.setSpareField2("\u62a5\u5e9f");
            }
            if (mouldLife.getMouldStatus() == 1) {
                mouldLife.setSpareField2("\u53ef\u7528");
            }
            if (mouldLife.getMouldStatus() == 2) {
                mouldLife.setSpareField2("\u8fc1\u79fb\u4e2d");
            }
            if (mouldLife.getMouldStatus() == 4) {
                mouldLife.setSpareField2("\u505c\u7528");
            }
            if (mouldLife.getMouldStatus() == 5) {
                mouldLife.setSpareField2("\u76d8\u4e8f");
            }
            if (mouldLife.getMouldStatus() == 3) {
                mouldLife.setSpareField2("\u7ef4\u4fee\u4e2d");
            }
            if (mouldLife.getSendStatus() == 0) {
                mouldLife.setSpareField3("\u672a\u53d1\u9001");
            }
            if (mouldLife.getSendStatus() == 1) {
                mouldLife.setSpareField3("\u5df2\u53d1\u9001");
            }
            if (mouldLife.getConfirmStatus() == 0) {
                mouldLife.setConceiveSupCompanyName("\u672a\u786e\u8ba4");
            }
            if (mouldLife.getConfirmStatus() == 1) {
                mouldLife.setConceiveSupCompanyName("\u5df2\u786e\u8ba4");
            }
            if (mouldLife.getConfirmStatus() == 2) {
                mouldLife.setConceiveSupCompanyName("\u5df2\u9000\u56de");
            }
            String startTime = DateFormatUtils.format((Date)mouldLife.getUsedStartTime(), (String)"yyyy-MM-dd");
            String endTime = DateFormatUtils.format((Date)mouldLife.getUsedEndTime(), (String)"yyyy-MM-dd");
            mouldLife.setProjectId(startTime);
            mouldLife.setPurCompanyId(endTime);
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, mouldLifes, "\u6a21\u5177\u5bff\u547d\u7ba1\u7406", "\u6a21\u5177\u5bff\u547d\u7ba1\u7406", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        if (CompanyUtils.isSupCompany()) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u9001\u72b6\u6001", (String)"spareField3"));
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u786e\u8ba4\u72b6\u6001", (String)"conceiveSupCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"mouldDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u72b6\u6001", (String)"spareField2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u540d\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177ID", (String)"mouldId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u673a\u578b", (String)"boardDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8154\u6570", (String)"cavityQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bf7\u65f6\u95f4", (String)"applyTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546SAP#", (String)"conceiveSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546\u540d\u79f0", (String)"conceiveSupCompanyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u5bff\u547d", (String)"designedLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u672c\u671f\u4f7f\u7528\u6a21\u6b21", (String)"mouldUsed"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u7b97\u671f\u95f4\u4ece", (String)"projectId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u7b97\u671f\u95f4\u81f3", (String)"purCompanyId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0a\u4f20\u65f6\u95f4", (String)"createDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4\u6233", (String)"operateTime"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldLife", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<MouldLife>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldLifeExample example = new MouldLifeExample();
        example.setPageView((PageView<MouldLife>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SPARE_FIELD4 DESC");
        MouldLifeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mouldLifeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6301\u6709\u4f9b\u5e94\u5546\u67e5\u8be2\u6a21\u5177\u5bff\u547d\u7ba1\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldLife", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<MouldLife>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldLifeExample example = new MouldLifeExample();
        example.setPageView((PageView<MouldLife>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_DATE DESC");
        MouldLifeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mouldLifeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

