/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.service.impl;

import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.notice.dao.MouldNoticeMapper;
import com.els.base.mould.notice.entity.MouldNotice;
import com.els.base.mould.notice.entity.MouldNoticeExample;
import com.els.base.mould.notice.entity.NoticeItem;
import com.els.base.mould.notice.entity.NoticeItemExample;
import com.els.base.mould.notice.service.MouldNoticeService;
import com.els.base.mould.notice.service.NoticeItemService;
import com.els.base.mould.notice.utils.BillStatus;
import com.els.base.mould.notice.utils.ConfirmStatus;
import com.els.base.mould.utils.MouldBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMouldNoticeService")
public class MouldNoticeServiceImpl
implements MouldNoticeService {
    @Resource
    protected MouldNoticeMapper mouldNoticeMapper;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private CompanyService companyService;
    @Resource
    private MouldService mouldService;
    @Resource
    private NoticeItemService noticeItemService;

    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void addObj(MouldNotice t) {
        this.mouldNoticeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void addAll(List<MouldNotice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.mouldNoticeMapper.insertBatch(list);
    }

    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldNoticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void deleteByExample(MouldNoticeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mouldNoticeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void modifyObj(MouldNotice t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.mouldNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"mouldNotice"}, keyGenerator="redisKeyGenerator")
    public MouldNotice queryObjById(String id) {
        return this.mouldNoticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"mouldNotice"}, keyGenerator="redisKeyGenerator")
    public List<MouldNotice> queryAllObjByExample(MouldNoticeExample example) {
        return this.mouldNoticeMapper.selectByExample(example);
    }

    @Cacheable(value={"mouldNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldNotice> queryObjByPage(MouldNoticeExample example) {
        PageView<MouldNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void abolish(List<String> ids, final User loginUser) {
        MouldNoticeExample example = new MouldNoticeExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldNotice> notices = this.mouldNoticeMapper.selectByExample(example);
        Assert.isNotEmpty(notices, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        for (MouldNotice mouldNotice : notices) {
            if (Constant.NO_INT.equals(mouldNotice.getSendStatus()) || BillStatus.ABOLISH.getCode().equals(mouldNotice.getBillStatus())) {
                throw new CommonException("\u901a\u77e5\u5355:" + mouldNotice.getNoticeNo() + "\u672a\u53d1\u9001\u6216\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u4f5c\u5e9f!");
            }
            NoticeItemExample example2 = new NoticeItemExample();
            example2.createCriteria().andNoticeIdEqualTo(mouldNotice.getId());
            List items = this.noticeItemService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)items, (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u5f00\u6a21\u901a\u77e5\u5355\u884c");
            for (NoticeItem noticeItem : items) {
                if (!ConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode().equals(noticeItem.getConfirmStatus())) continue;
                throw new CommonException("\u5355\u53f7:" + mouldNotice.getNoticeNo() + "\u542b\u6709\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4\u7684\u884c\u9879\u76ee,\u4e0d\u5141\u8bb8\u4f5c\u5e9f!");
            }
            mouldNotice.setId(mouldNotice.getId());
            mouldNotice.setBillStatus(BillStatus.ABOLISH.getCode());
            mouldNotice.setUpdateUser(loginUser.getNickName());
            mouldNotice.setUpdateTime(new Date());
            this.mouldNoticeMapper.updateByPrimaryKeySelective(mouldNotice);
        }
        List<MouldNotice> list = this.queryAllObjByExample(example);
        for (final MouldNotice mouldNotice : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    MouldNoticeServiceImpl.this.sendMessagesToMouldSup(loginUser, mouldNotice, MouldBusinessEnum.MOULD_NOTICE_ABOLISH.getCode());
                    MouldNoticeServiceImpl.this.sendMessagesToConceiveSup(loginUser, mouldNotice, MouldBusinessEnum.MOULD_NOTICE_ABOLISH.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void sendToSup(List<String> ids, final User loginUser) {
        MouldNoticeExample example = new MouldNoticeExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldNotice> notices = this.mouldNoticeMapper.selectByExample(example);
        Assert.isNotEmpty(notices, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        for (MouldNotice mouldNotice : notices) {
            mouldNotice.setId(mouldNotice.getId());
            mouldNotice.setSendStatus(Constant.YES_INT);
            mouldNotice.setUpdateUser(loginUser.getNickName());
            mouldNotice.setSendTime(new Date());
            this.mouldNoticeMapper.updateByPrimaryKeySelective(mouldNotice);
        }
        List<MouldNotice> list = this.queryAllObjByExample(example);
        for (final MouldNotice mouldNotice : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    MouldNoticeServiceImpl.this.sendMessagesToMouldSup(loginUser, mouldNotice, MouldBusinessEnum.MOULD_NOTICE_SEND.getCode());
                    MouldNoticeServiceImpl.this.sendMessagesToConceiveSup(loginUser, mouldNotice, MouldBusinessEnum.MOULD_NOTICE_SEND.getCode());
                }
            });
        }
    }

    protected void sendMessagesToConceiveSup(User loginUser, MouldNotice data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToMouldSup(User loginUser, MouldNotice data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getMouldSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToPur(User loginUser, MouldNotice data, String businessType) {
        User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }
}

