/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.relation.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.ExcelFileData;
import com.els.base.mould.relation.command.CreateCommand;
import com.els.base.mould.relation.command.ModifyCommand;
import com.els.base.mould.relation.entity.Relation;
import com.els.base.mould.relation.entity.RelationExample;
import com.els.base.mould.relation.service.RelationService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u6a21\u5177\u7269\u6599\u5173\u7cfb")
@Controller
@RequestMapping(value={"relation"})
public class RelationController {
    @Resource
    protected RelationService relationService;
    @Resource
    protected MouldInvorker mouldInvorker;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MouldService mouldService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u5177\u7269\u6599\u5173\u7cfb")
    @RequestMapping(value={"service/save"})
    @ResponseBody
    public ResponseResult<String> save(@RequestBody Relation relation) {
        Assert.isNotNull((Object)relation, (String)"\u5173\u7cfb\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)relation.getMaterialNo(), (String)"\u7269\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)relation.getMouldNo(), (String)"\u6a21\u5177\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        MouldExample example = new MouldExample();
        example.createCriteria().andMouldNoEqualTo(relation.getMouldNo());
        List moulds = this.mouldService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)moulds, (String)("\u6a21\u5177\u7f16\u53f7" + relation.getMouldNo() + "\u672a\u5728\u4e3b\u6570\u636e\u7ef4\u62a4,\u8bf7\u5148\u7ef4\u62a4\u4e3b\u6570\u636e"));
        MaterialExample example2 = new MaterialExample();
        example2.createCriteria().andMaterialCodeEqualTo(relation.getMaterialNo());
        List list = this.materialService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)list, (String)("\u7269\u6599\u4e3b\u6570\u636e\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u6599\u7f16\u53f7:" + relation.getMaterialNo()));
        AbstractMouldCommand command = null;
        command = StringUtils.isEmpty((String)relation.getId()) ? new CreateCommand(relation) : new ModifyCommand(relation);
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6a21\u5177\u7269\u6599\u5173\u7cfb")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Relation relation) {
        Assert.isNotBlank((String)relation.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.relationService.modifyObj(relation);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6a21\u5177\u7269\u6599\u5173\u7cfb")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.relationService.deleteByids(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u6a21\u5177\u7269\u6599\u5173\u7cfb")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<Relation> findDetailById(@RequestBody String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        Relation relation = (Relation)this.relationService.queryObjById(id);
        return ResponseResult.success((Object)relation);
    }

    @ApiOperation(value="\u5bfc\u51faExcel\u6a21\u677f", httpMethod="POST")
    @RequestMapping(value={"service/exportToExcel"})
    @ResponseBody
    public void exportToExcel(HttpServletResponse response) throws Exception {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u6a21\u5177\u7269\u6599\u5173\u7cfbExcel\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"\u6a21\u5177\u7269\u6599\u5173\u7cfbExcel\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
    }

    private List<TitleAndModelKey> createExcelHeaderColumn() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u53f7", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u6599\u8bf4\u660e", (String)"materialInstruction"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        RelationExample example = new RelationExample();
        example.setOrderByClause("CREATE_TIME DESC");
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        }
        List relations = null;
        if (CollectionUtils.isEmpty(ids)) {
            example.createCriteria().andIsEnableEqualTo("N");
            relations = this.relationService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)relations, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            example.createCriteria().andIsEnableEqualTo("N").andIdIn((List)ids);
            relations = this.relationService.queryAllObjByExample((IExample)example);
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, relations, "\u6a21\u5177\u7269\u6599\u5173\u7cfb", "\u6a21\u5177\u7269\u6599\u5173\u7cfb", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u53f7", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u6599\u8bf4\u660e", (String)"materialInstruction"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5220\u9664\u6807\u8bc6", (String)"isEnable"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165Excel", httpMethod="POST")
    @RequestMapping(value={"service/importFromExcel"})
    @ResponseBody
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
        int i = 0;
        try {
            i = this.relationService.importExcel(file, titleAndModelKeys, SpringSecurityUtils.getLoginUser());
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage());
        }
        return ResponseResult.success((Object)("\u6210\u529f\u5bfc\u5165" + i + "\u6761\u8bb0\u5f55!"));
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301xls");
        }
        return file;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6a21\u5177\u7269\u6599\u5173\u7cfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Relation", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Relation>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RelationExample example = new RelationExample();
        example.setPageView((PageView<Relation>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RelationExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.relationService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

