/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.relation.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.relation.dao.RelationMapper;
import com.els.base.mould.relation.entity.Relation;
import com.els.base.mould.relation.entity.RelationExample;
import com.els.base.mould.relation.service.RelationService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="defaultRelationService")
public class RelationServiceImpl
implements RelationService {
    @Resource
    protected RelationMapper relationMapper;
    @Resource
    protected MouldService mouldService;
    @Resource
    protected MaterialService materialService;

    @CacheEvict(value={"relation"}, allEntries=true)
    public void addObj(Relation t) {
        this.relationMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"relation"}, allEntries=true)
    public void addAll(List<Relation> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.relationMapper.insertBatch(list);
    }

    @CacheEvict(value={"relation"}, allEntries=true)
    public void deleteObjById(String id) {
        this.relationMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"relation"}, allEntries=true)
    public void deleteByExample(RelationExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.relationMapper.deleteByExample(example);
    }

    @CacheEvict(value={"relation"}, allEntries=true)
    public void modifyObj(Relation t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.relationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"relation"}, keyGenerator="redisKeyGenerator")
    public Relation queryObjById(String id) {
        return this.relationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"relation"}, keyGenerator="redisKeyGenerator")
    public List<Relation> queryAllObjByExample(RelationExample example) {
        return this.relationMapper.selectByExample(example);
    }

    @Cacheable(value={"relation"}, keyGenerator="redisKeyGenerator")
    public PageView<Relation> queryObjByPage(RelationExample example) {
        PageView<Relation> pageView = example.getPageView();
        pageView.setQueryResult(this.relationMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"relation"}, allEntries=true)
    public void deleteByids(List<String> ids, User user) {
        RelationExample example = new RelationExample();
        example.createCriteria().andIdIn((List)ids);
        Relation relation = new Relation();
        relation.setIsEnable("Y");
        relation.setUpdateTime(new Date());
        relation.setUpdateUserName(user.getNickName());
        this.relationMapper.updateByExampleSelective(relation, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"relation"}, allEntries=true)
    public int importExcel(MultipartFile file, List<TitleAndModelKey> titleAndModelKeys, User user) throws IOException, Exception {
        List relations = null;
        relations = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Relation.class);
        Assert.isNotEmpty((Collection)relations, (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (Relation relation : relations) {
            Assert.isNotBlank((String)relation.getMouldNo(), (String)"\u6a21\u5177\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)relation.getMaterialNo(), (String)"\u7269\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            MouldExample example = new MouldExample();
            example.createCriteria().andMouldNoEqualTo(relation.getMouldNo());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)moulds, (String)("\u6a21\u5177\u7f16\u53f7" + relation.getMouldNo() + "\u672a\u5728\u4e3b\u6570\u636e\u7ef4\u62a4,\u8bf7\u5148\u7ef4\u62a4\u4e3b\u6570\u636e!"));
            this.completeInfo(relation, ProjectUtils.getProjectId(), user);
            RelationExample example2 = new RelationExample();
            example2.createCriteria().andMouldNoEqualTo(relation.getMouldNo()).andMaterialNoEqualTo(relation.getMaterialNo()).andIsEnableEqualTo("N");
            int i = this.relationMapper.countByExample(example2);
            if (i > 0) {
                this.relationMapper.deleteByExample(example2);
            }
            this.addObj(relation);
        }
        return relations.size();
    }

    private void completeInfo(Relation relation, String projectId, User user) {
        relation.setId(UUIDGenerator.generateUUID());
        relation.setCreateTime(new Date());
        relation.setCreateUserName(user.getNickName());
        relation.setProjectId(ProjectUtils.getProjectId());
        relation.setIsEnable("N");
        MaterialExample example2 = new MaterialExample();
        example2.createCriteria().andMaterialCodeEqualTo(relation.getMaterialNo());
        List list = this.materialService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)list, (String)("\u7269\u6599\u4e3b\u6570\u636e\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u6599\u7f16\u53f7:" + relation.getMaterialNo() + ",\u5bfc\u5165\u5931\u8d25!"));
        relation.setMaterialDesc(((Material)list.get(0)).getDescription());
        relation.setCategory(((Material)list.get(0)).getMaterialCategory());
    }

    @Override
    @Cacheable(value={"relation"}, keyGenerator="redisKeyGenerator")
    public int countByexample(RelationExample example) {
        return this.relationMapper.countByExample(example);
    }
}

