/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.repair.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.repair.dao.RepairMapper;
import com.els.base.mould.repair.entity.Repair;
import com.els.base.mould.repair.entity.RepairExample;
import com.els.base.mould.repair.service.RepairService;
import com.els.base.mould.repair.utils.RepairStatus;
import com.els.base.mould.utils.MouldBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultRepairService")
public class RepairServiceImpl
implements RepairService {
    @Resource
    protected RepairMapper repairMapper;
    @Resource
    protected MouldService mouldService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;

    @CacheEvict(value={"repair"}, allEntries=true)
    public void addObj(Repair t) {
        this.repairMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"repair"}, allEntries=true)
    @Transactional
    public void insert(Repair repair, User user) {
        if (repair.getForecastCompleteTime() == null) {
            throw new CommonException("\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Assert.isNotNull((Object)repair.getRepairWay(), (String)"\u7ef4\u4fee\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)repair.getRepairReason(), (String)"\u7ef4\u4fee\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        repair.setApplyTime(new Date());
        repair.setApplyUserName(user.getNickName());
        this.repairMapper.insertSelective(repair);
        MouldExample mouldExample = new MouldExample();
        mouldExample.createCriteria().andMouldIdEqualTo(repair.getMouldId());
        List list = this.mouldService.queryAllObjByExample((IExample)mouldExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Mould mould : list) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.REPAIR.getCode());
                this.mouldService.modifyObj(mould);
            }
        }
    }

    @Transactional
    @CacheEvict(value={"repair"}, allEntries=true)
    public void addAll(List<Repair> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.repairMapper.insertBatch(list);
    }

    @CacheEvict(value={"repair"}, allEntries=true)
    public void deleteObjById(String id) {
        this.repairMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"repair"}, allEntries=true)
    public void deleteByExample(RepairExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.repairMapper.deleteByExample(example);
    }

    @CacheEvict(value={"repair"}, allEntries=true)
    public void modifyObj(Repair t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.repairMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"repair"}, keyGenerator="redisKeyGenerator")
    public Repair queryObjById(String id) {
        return this.repairMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"repair"}, keyGenerator="redisKeyGenerator")
    public List<Repair> queryAllObjByExample(RepairExample example) {
        return this.repairMapper.selectByExample(example);
    }

    @Cacheable(value={"repair"}, keyGenerator="redisKeyGenerator")
    public PageView<Repair> queryObjByPage(RepairExample example) {
        PageView<Repair> pageView = example.getPageView();
        pageView.setQueryResult(this.repairMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @Cacheable(value={"repair"}, keyGenerator="redisKeyGenerator")
    public Repair prepareForPur(List<String> ids, Company currentCompany, User loginUser) {
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)ids);
        List moulds = this.mouldService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177\u4e3b\u6570\u636e!");
        for (Mould mould : moulds) {
            if (MouldStatus.USABLE.getCode().equals(mould.getMouldStatus())) continue;
            throw new CommonException("\u53ea\u6709\u6a21\u5177\u72b6\u6001\u4e3a\u53ef\u7528\u7684\u6a21\u5177\u624d\u80fd\u751f\u6210\u7ef4\u4fee\u5355!");
        }
        Mould mould = (Mould)moulds.get(0);
        Repair repair = new Repair();
        this.complete(mould, currentCompany, loginUser, repair);
        return repair;
    }

    private void complete(Mould mould, Company currentCompany, User loginUser, Repair repair) {
        this.completePurAndSup(mould, currentCompany, repair);
        repair.setProjectId(mould.getProjectId());
        repair.setRepairNo(UUIDGenerator.generateUUID());
        repair.setRepairType(Constant.YES_INT);
        repair.setCompanyCode(mould.getCompanyCode());
        repair.setCompanyName(mould.getCompanyName());
        repair.setSendStatus(Constant.NO_INT);
        repair.setRepairStatus(RepairStatus.NO_CONFIRM.getCode());
        repair.setMouldId(mould.getMouldId());
        repair.setMouldNo(mould.getMouldNo());
        repair.setMouldDesc(mould.getMouldDesc());
        repair.setMouldNumber(mould.getMouldNumber());
        repair.setIsEnable(Constant.YES_INT);
    }

    private void completePurAndSup(Mould mould, Company currentCompany, Repair repair) {
        repair.setConceiveSupCompanyId(currentCompany.getId());
        repair.setConceiveSupCompanyFullName(currentCompany.getCompanyFullName());
        repair.setConceiveSupCompanyName(currentCompany.getCompanyName());
        repair.setConceiveSupCompanySapCode(currentCompany.getCompanySapCode());
        repair.setConceiveSupCompanySrmCode(currentCompany.getCompanyCode());
        repair.setPurCompanyFullName(mould.getPurCompanyFullName());
        repair.setPurCompanyId(mould.getPurCompanyId());
        repair.setPurCompanyName(mould.getPurCompanyName());
        repair.setPurCompanySapCode(mould.getPurCompanySapCode());
        repair.setPurCompanySrmCode(mould.getPurCompanySrmCode());
    }

    @Override
    @CacheEvict(value={"repair"}, allEntries=true)
    public void abolishSup(List<String> ids, final User user) {
        RepairExample example = new RepairExample();
        example.createCriteria().andIdIn((List)ids);
        List<Repair> repairs = this.repairMapper.selectByExample(example);
        Assert.isNotEmpty(repairs, (String)"\u672a\u627e\u5230\u8be5\u7ef4\u4fee\u5355");
        for (Repair repair : repairs) {
            if (RepairStatus.SUP_CONFIRM.getCode().equals(repair.getRepairStatus()) || Constant.NO_INT.equals(repair.getSendStatus()) || RepairStatus.ABOLISH.getCode().equals(repair.getRepairStatus()) || RepairStatus.PUR_CONFIRM.getCode().equals(repair.getRepairStatus()) || RepairStatus.PUR_REJECT.getCode().equals(repair.getRepairStatus())) {
                throw new CommonException("\u8be5\u7ef4\u4fee\u5355\u672a\u53d1\u9001\u6216\u5df2\u5b8c\u6210\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u786e\u8ba4\u6216\u5df2\u5173\u95ed,\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            }
            repair.setId(repair.getId());
            repair.setRepairStatus(RepairStatus.ABOLISH.getCode());
            this.repairMapper.updateByPrimaryKeySelective(repair);
            MouldExample example2 = new MouldExample();
            example2.createCriteria().andMouldIdEqualTo(repair.getMouldId());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u8be5\u6a21\u5177");
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.USABLE.getCode());
                this.mouldService.modifyObj(mould);
            }
        }
        List<Repair> list = this.queryAllObjByExample(example);
        for (final Repair repair2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RepairServiceImpl.this.sendMessagesToPur(user, repair2, MouldBusinessEnum.MOULD_REPAIR_ABOLISH.getCode());
                }
            });
        }
    }

    protected void sendMessagesToPur(User loginUser, Repair data, String businessType) {
        User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToConceiveSup(User loginUser, Repair data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"repair"}, allEntries=true)
    public void deleteByids(List<String> ids, User user) {
        RepairExample example = new RepairExample();
        example.createCriteria().andIdIn((List)ids);
        List<Repair> repairs = this.repairMapper.selectByExample(example);
        Assert.isNotEmpty(repairs, (String)"\u672a\u627e\u5230\u8be5\u7ef4\u4fee\u5355");
        String did = null;
        for (Repair repair : repairs) {
            if (Constant.YES_INT.equals(repair.getSendStatus())) {
                throw new CommonException("\u7ef4\u4fee\u5355" + repair.getRepairNo() + "\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            did = repair.getMouldId();
            repair.setId(repair.getId());
            repair.setIsEnable(Constant.NO_INT);
            this.repairMapper.updateByPrimaryKeySelective(repair);
            MouldExample example2 = new MouldExample();
            example2.createCriteria().andMouldIdEqualTo(did);
            List moulds = this.mouldService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u8be5\u6a21\u5177");
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.USABLE.getCode());
                this.mouldService.modifyObj(mould);
            }
        }
    }

    @Override
    @CacheEvict(value={"repair"}, allEntries=true)
    public void sendToPur(List<String> ids, final User user) {
        RepairExample example = new RepairExample();
        example.createCriteria().andIdIn((List)ids);
        List<Repair> repairs = this.repairMapper.selectByExample(example);
        Assert.isNotEmpty(repairs, (String)"\u672a\u627e\u5230\u8be5\u7ef4\u4fee\u5355");
        for (Repair repair : repairs) {
            if (Constant.NO_INT.equals(repair.getIsEnable())) {
                throw new CommonException("\u7ef4\u4fee\u5355" + repair.getRepairNo() + "\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u518d\u64cd\u4f5c");
            }
            repair.setId(repair.getId());
            repair.setSendStatus(Constant.YES_INT);
            repair.setSendTime(new Date());
            this.repairMapper.updateByPrimaryKeySelective(repair);
        }
        List<Repair> list = this.queryAllObjByExample(example);
        for (final Repair repair2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RepairServiceImpl.this.sendMessagesToPur(user, repair2, MouldBusinessEnum.MOULD_REPAIR_SEND.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"repair"}, allEntries=true)
    public void confirmForPur(List<String> ids, final User user) {
        RepairExample example = new RepairExample();
        example.createCriteria().andIdIn((List)ids);
        List<Repair> repairs = this.repairMapper.selectByExample(example);
        Assert.isNotEmpty(repairs, (String)"\u672a\u627e\u5230\u8be5\u7ef4\u4fee\u5355");
        for (Repair repair : repairs) {
            if (RepairStatus.PUR_CONFIRM.getCode().equals(repair.getRepairStatus()) || RepairStatus.PUR_REJECT.getCode().equals(repair.getRepairStatus()) || RepairStatus.SUP_CONFIRM.getCode().equals(repair.getRepairStatus()) || RepairStatus.ABOLISH.getCode().equals(repair.getRepairStatus())) {
                throw new CommonException("\u7ef4\u4fee\u5355" + repair.getRepairNo() + "\u5df2\u786e\u8ba4\u6216\u5df2\u5b8c\u6210\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u5173\u95ed,\u4e0d\u5141\u8bb8\u786e\u8ba4\u5355\u636e");
            }
            repair.setId(repair.getId());
            repair.setRepairStatus(RepairStatus.PUR_CONFIRM.getCode());
            repair.setConfirmTime(new Date());
            this.repairMapper.updateByPrimaryKeySelective(repair);
            MouldExample example2 = new MouldExample();
            example2.createCriteria().andMouldIdEqualTo(repair.getMouldId());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u8be5\u6a21\u5177");
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.REPAIR.getCode());
                this.mouldService.modifyObj(mould);
            }
        }
        List<Repair> list = this.queryAllObjByExample(example);
        for (final Repair repair2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RepairServiceImpl.this.sendMessagesToConceiveSup(user, repair2, MouldBusinessEnum.MOULD_REPAIR_PUR_CONFIRM.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"repair"}, allEntries=true)
    public void rejectForPur(List<String> ids, final User user) {
        RepairExample example = new RepairExample();
        example.createCriteria().andIdIn((List)ids);
        List<Repair> repairs = this.repairMapper.selectByExample(example);
        Assert.isNotEmpty(repairs, (String)"\u672a\u627e\u5230\u8be5\u7ef4\u4fee\u5355");
        for (Repair repair : repairs) {
            if (RepairStatus.PUR_CONFIRM.getCode().equals(repair.getRepairStatus()) || RepairStatus.PUR_REJECT.getCode().equals(repair.getRepairStatus()) || RepairStatus.SUP_CONFIRM.getCode().equals(repair.getRepairStatus()) || RepairStatus.ABOLISH.getCode().equals(repair.getRepairStatus())) {
                throw new CommonException("\u7ef4\u4fee\u5355" + repair.getRepairNo() + "\u5df2\u786e\u8ba4\u6216\u5df2\u5b8c\u6210\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u5173\u95ed,\u4e0d\u5141\u8bb8\u62d2\u7edd\u5355\u636e");
            }
            repair.setId(repair.getId());
            repair.setRepairStatus(RepairStatus.PUR_REJECT.getCode());
            this.repairMapper.updateByPrimaryKeySelective(repair);
            MouldExample example2 = new MouldExample();
            example2.createCriteria().andMouldIdEqualTo(repair.getMouldId());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u8be5\u6a21\u5177");
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.USABLE.getCode());
                this.mouldService.modifyObj(mould);
            }
        }
        List<Repair> list = this.queryAllObjByExample(example);
        for (final Repair repair2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RepairServiceImpl.this.sendMessagesToConceiveSup(user, repair2, MouldBusinessEnum.MOULD_REPAIR_PUR_REJECT.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"repair"}, allEntries=true)
    public void confirmForSup(List<String> ids, final User user) {
        RepairExample example = new RepairExample();
        example.createCriteria().andIdIn((List)ids);
        List<Repair> repairs = this.repairMapper.selectByExample(example);
        Assert.isNotEmpty(repairs, (String)"\u672a\u627e\u5230\u8be5\u7ef4\u4fee\u5355");
        for (Repair repair : repairs) {
            if (RepairStatus.NO_CONFIRM.getCode().equals(repair.getRepairStatus()) || RepairStatus.PUR_REJECT.getCode().equals(repair.getRepairStatus()) || RepairStatus.SUP_CONFIRM.getCode().equals(repair.getRepairStatus()) || RepairStatus.ABOLISH.getCode().equals(repair.getRepairStatus())) {
                throw new CommonException("\u7ef4\u4fee\u5355" + repair.getRepairNo() + "\u672a\u786e\u8ba4\u6216\u5df2\u5b8c\u6210\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u5173\u95ed,\u4e0d\u5141\u8bb8\u5b8c\u6210\u5355\u636e");
            }
            repair.setId(repair.getId());
            repair.setRepairStatus(RepairStatus.SUP_CONFIRM.getCode());
            repair.setCompletedTime(new Date());
            this.repairMapper.updateByPrimaryKeySelective(repair);
            MouldExample example2 = new MouldExample();
            example2.createCriteria().andMouldIdEqualTo(repair.getMouldId());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u8be5\u6a21\u5177");
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.USABLE.getCode());
                mould.setRecentMaintenanceDate(new Date());
                this.mouldService.modifyObj(mould);
            }
        }
        List<Repair> list = this.queryAllObjByExample(example);
        for (final Repair repair2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RepairServiceImpl.this.sendMessagesToPur(user, repair2, MouldBusinessEnum.MOULD_REPAIR_SUP_CONFIRM.getCode());
                }
            });
        }
    }
}

