/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.roller.dao.RollerFormFileMapper;
import com.els.base.mould.roller.entity.RollerFormFile;
import com.els.base.mould.roller.entity.RollerFormFileExample;
import com.els.base.mould.roller.entity.RollerNotice;
import com.els.base.mould.roller.entity.RollerNoticeExample;
import com.els.base.mould.roller.service.RollerFormFileService;
import com.els.base.mould.roller.service.RollerNoticeService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultRollerFormFileService")
public class RollerFormFileServiceImpl
implements RollerFormFileService {
    @Resource
    protected RollerFormFileMapper rollerFormFileMapper;
    @Resource
    protected RollerNoticeService rollerNoticeService;

    @CacheEvict(value={"rollerFormFile"}, allEntries=true)
    public void addObj(RollerFormFile t) {
        this.rollerFormFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"rollerFormFile"}, allEntries=true)
    public void addAll(List<RollerFormFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.rollerFormFileMapper.insertBatch(list);
    }

    @CacheEvict(value={"rollerFormFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.rollerFormFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"rollerFormFile"}, allEntries=true)
    public void deleteByExample(RollerFormFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.rollerFormFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"rollerFormFile"}, allEntries=true)
    public void modifyObj(RollerFormFile t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.rollerFormFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"rollerFormFile"}, keyGenerator="redisKeyGenerator")
    public RollerFormFile queryObjById(String id) {
        return this.rollerFormFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"rollerFormFile"}, keyGenerator="redisKeyGenerator")
    public List<RollerFormFile> queryAllObjByExample(RollerFormFileExample example) {
        return this.rollerFormFileMapper.selectByExample(example);
    }

    @Cacheable(value={"rollerFormFile"}, keyGenerator="redisKeyGenerator")
    public PageView<RollerFormFile> queryObjByPage(RollerFormFileExample example) {
        PageView<RollerFormFile> pageView = example.getPageView();
        pageView.setQueryResult(this.rollerFormFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"rollerFormFile"}, keyGenerator="redisKeyGenerator")
    public List<RollerFormFile> queryByRollerItemNo(String itemNo) {
        Assert.isNotBlank((String)itemNo, (String)"\u901a\u77e5\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        RollerFormFileExample example = new RollerFormFileExample();
        example.createCriteria().andRollerItemNoEqualTo(itemNo);
        return this.rollerFormFileMapper.selectByExample(example);
    }

    @Override
    public void deleteByExample(List<String> ids) {
        RollerFormFileExample example = new RollerFormFileExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerFormFile> list = this.rollerFormFileMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            RollerNoticeExample example2 = new RollerNoticeExample();
            example.createCriteria().andRollerNoEqualTo(list.get(0).getRollerNo());
            List notices = this.rollerNoticeService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)notices, (String)"\u672a\u627e\u5230\u76f8\u5e94\u901a\u77e5\u5355");
            if (Constant.YES_INT.equals(((RollerNotice)notices.get(0)).getSendStatus())) {
                throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        }
        for (RollerFormFile rollerFormFile : list) {
            rollerFormFile.setIsEnable(Constant.YES_INT);
            this.rollerFormFileMapper.updateByExample(rollerFormFile, example);
        }
    }
}

