/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.dao.RollerNoticeItemMapper;
import com.els.base.mould.roller.dao.RollerNoticeMapper;
import com.els.base.mould.roller.entity.RollerNotice;
import com.els.base.mould.roller.entity.RollerNoticeExample;
import com.els.base.mould.roller.entity.RollerNoticeItem;
import com.els.base.mould.roller.entity.RollerNoticeItemExample;
import com.els.base.mould.roller.master.entity.Roller;
import com.els.base.mould.roller.master.entity.RollerExample;
import com.els.base.mould.roller.master.service.RollerService;
import com.els.base.mould.roller.master.utils.RollerStatus;
import com.els.base.mould.roller.service.RollerNoticeItemService;
import com.els.base.mould.roller.service.RollerNoticeService;
import com.els.base.mould.roller.utlis.RollerBillStatus;
import com.els.base.mould.roller.utlis.RollerBusinessEnum;
import com.els.base.mould.roller.utlis.RollerConfirmStatus;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultRollerNoticeItemService")
public class RollerNoticeItemServiceImpl
implements RollerNoticeItemService {
    @Resource
    protected RollerNoticeItemMapper rollerNoticeItemMapper;
    @Resource
    protected RollerNoticeService rollerNoticeService;
    @Resource
    protected RollerNoticeMapper rollerNoticeMapper;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private RollerService rollerService;
    @Resource
    private CompanyService companyService;
    @Resource
    private MouldInvorker mouldInvorker;

    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void addObj(RollerNoticeItem t) {
        this.rollerNoticeItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void addAll(List<RollerNoticeItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.rollerNoticeItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.rollerNoticeItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void deleteByExample(RollerNoticeItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.rollerNoticeItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void modifyObj(RollerNoticeItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.rollerNoticeItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"rollerNoticeItem"}, keyGenerator="redisKeyGenerator")
    public RollerNoticeItem queryObjById(String id) {
        return this.rollerNoticeItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"rollerNoticeItem"}, keyGenerator="redisKeyGenerator")
    public List<RollerNoticeItem> queryAllObjByExample(RollerNoticeItemExample example) {
        return this.rollerNoticeItemMapper.selectByExample(example);
    }

    @Cacheable(value={"rollerNoticeItem"}, keyGenerator="redisKeyGenerator")
    public PageView<RollerNoticeItem> queryObjByPage(RollerNoticeItemExample example) {
        PageView<RollerNoticeItem> pageView = example.getPageView();
        pageView.setQueryResult(this.rollerNoticeItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"rollerNoticeItem"}, keyGenerator="redisKeyGenerator")
    public List<RollerNoticeItem> queryByNoticeId(String id) {
        Assert.isNotBlank((String)id, (String)"\u901a\u77e5\u5355\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        RollerNoticeItemExample example = new RollerNoticeItemExample();
        example.createCriteria().andNoticeIdEqualTo(id);
        return this.rollerNoticeItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"rollerNoticeItem"}, keyGenerator="redisKeyGenerator")
    public int countByExample(RollerNoticeItemExample example) {
        return this.rollerNoticeItemMapper.countByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void deleteObjByIds(List<String> ids) {
        RollerNoticeItemExample example = new RollerNoticeItemExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerNoticeItem> items = this.rollerNoticeItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u6ca1\u6709\u627e\u5230\u5236\u7248\u901a\u77e5\u5355\u884c");
        RollerNoticeExample example2 = new RollerNoticeExample();
        example.createCriteria().andIdEqualTo(items.get(0).getNoticeId());
        List notice = this.rollerNoticeService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)notice, (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u5236\u7248\u901a\u77e5\u5355\u53f7");
        RollerNotice rollerNotice = (RollerNotice)notice.get(0);
        if (Constant.YES_INT.equals(rollerNotice.getSendStatus())) {
            throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        for (RollerNoticeItem item : items) {
            item.setIsEnable("Y");
            item.setConfirmStatus(RollerConfirmStatus.DELETED.getCode());
            this.rollerNoticeItemMapper.updateByExample(item, example);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void insert(RollerNoticeItem rollerNoticeItem) {
        RollerNoticeExample example = new RollerNoticeExample();
        example.createCriteria().andRollerNoEqualTo(rollerNoticeItem.getNoticeNo());
        List notice = this.rollerNoticeService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)notice, (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u5236\u7248\u901a\u77e5\u5355\u53f7");
        RollerNotice rollerNotice = (RollerNotice)notice.get(0);
        if (Constant.YES_INT.equals(rollerNotice.getSendStatus())) {
            throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u6dfb\u52a0");
        }
        this.compele(rollerNoticeItem, rollerNotice);
        rollerNoticeItem.setId(UUIDGenerator.generateUUID());
        rollerNoticeItem.setItemNo(UUIDGenerator.generateUUID());
        rollerNoticeItem.setConfirmStatus(RollerConfirmStatus.NO_CONFIRM.getCode());
        rollerNoticeItem.setCompanyCode(rollerNotice.getCompanyCode());
        rollerNoticeItem.setCompanyName(rollerNotice.getCompanyName());
        rollerNoticeItem.setNoticeId(rollerNotice.getId());
        rollerNoticeItem.setIsEnable("N");
        String rollerNo = rollerNoticeItem.getRollerNo();
        RollerExample example2 = new RollerExample();
        example2.createCriteria().andPlateIdLike(rollerNo + "___");
        int i = this.rollerService.countByExample(example2);
        RollerNoticeItemExample example3 = new RollerNoticeItemExample();
        example3.createCriteria().andRollerIdLike(rollerNo + "___");
        int j = this.rollerNoticeItemMapper.countByExample(example3);
        String id = String.format("%s%03d", rollerNo, i + j + 1);
        rollerNoticeItem.setRollerId(id);
        this.addObj(rollerNoticeItem);
    }

    private void compele(RollerNoticeItem rollerNoticeItem, RollerNotice rollerNotice) {
        rollerNoticeItem.setPurCompanyId(rollerNotice.getPurCompanyId());
        rollerNoticeItem.setPurCompanyFullName(rollerNotice.getPurCompanyFullName());
        rollerNoticeItem.setPurCompanyName(rollerNotice.getPurCompanyName());
        rollerNoticeItem.setPurCompanySrmCode(rollerNotice.getPurCompanySrmCode());
        rollerNoticeItem.setRollerSupCompanyId(rollerNotice.getRollerSupCompanyId());
        rollerNoticeItem.setRollerSupCompanyName(rollerNotice.getRollerSupCompanyName());
        rollerNoticeItem.setRollerSupCompanyFullName(rollerNotice.getRollerSupCompanyFullName());
        rollerNoticeItem.setRollerSupCompanySapCode(rollerNotice.getRollerSupCompanySapCode());
        rollerNoticeItem.setRollerSupCompanySrmCode(rollerNotice.getRollerSupCompanySrmCode());
        rollerNoticeItem.setConceiveSupCompanyId(rollerNotice.getConceiveSupCompanyId());
        rollerNoticeItem.setConceiveSupCompanyName(rollerNotice.getConceiveSupCompanyName());
        rollerNoticeItem.setConceiveSupCompanyFullName(rollerNotice.getConceiveSupCompanyFullName());
        rollerNoticeItem.setConceiveSupCompanySapCode(rollerNotice.getConceiveSupCompanySapCode());
        rollerNoticeItem.setConceiveSupCompanySrmCode(rollerNotice.getConceiveSupCompanySrmCode());
    }

    @Override
    @Transactional
    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void conceiveSupConfirm(List<String> ids, final User loginUser) {
        RollerNoticeItemExample example = new RollerNoticeItemExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerNoticeItem> items = this.rollerNoticeItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u901a\u77e5\u5355\u884c");
        RollerNoticeExample example2 = new RollerNoticeExample();
        example2.createCriteria().andIdEqualTo(items.get(0).getNoticeId());
        List notices = this.rollerNoticeService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)notices, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        RollerNotice rollerNotice = (RollerNotice)notices.get(0);
        if (rollerNotice.getBillStatus().equals(RollerBillStatus.ABOLISH.getValue())) {
            throw new CommonException("\u901a\u77e5\u5355:" + rollerNotice.getRollerNo() + "\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
        }
        for (RollerNoticeItem item : items) {
            if (item.getConfirmStatus().equals(RollerConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            item.setId(item.getId());
            item.setConfirmStatus(RollerConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode());
            item.setClosingTime(new Date());
            this.rollerNoticeItemMapper.updateByPrimaryKeySelective(item);
        }
        example.clear();
        example.createCriteria().andNoticeIdEqualTo(((RollerNotice)notices.get(0)).getId());
        List<RollerNoticeItem> list = this.rollerNoticeItemMapper.selectByExample(example);
        Set status = list.stream().map(i -> i.getConfirmStatus()).collect(Collectors.toSet());
        if (status.size() == 1) {
            rollerNotice.setBillStatus(RollerBillStatus.ROLLER_HANDOVER.getValue());
        } else {
            rollerNotice.setBillStatus(RollerBillStatus.PART_ROLLER_HANDOVER.getValue());
        }
        this.rollerNoticeService.modifyObj(rollerNotice);
        this.addRoller(rollerNotice, items, loginUser);
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<RollerNoticeItem> itemAxampla = this.queryAllObjByExample(example);
        for (final RollerNoticeItem rollerNoticeItem : itemAxampla) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RollerNoticeItemServiceImpl.this.sendMessagesToRollerSup(loginUser, rollerNoticeItem, RollerBusinessEnum.CON_SUP_CONFIRM.getCode());
                    RollerNoticeItemServiceImpl.this.sendMessagesToPur(loginUser, rollerNoticeItem, RollerBusinessEnum.CON_SUP_CONFIRM.getCode());
                }
            });
        }
    }

    private void addRoller(RollerNotice rollerNotice, List<RollerNoticeItem> items, User loginUser) {
        for (RollerNoticeItem rollerNoticeItem : items) {
            Roller roller = new Roller();
            roller.setId(UUIDGenerator.generateUUID());
            roller.setProjectId(rollerNotice.getProjectId());
            roller.setPlateNumber(rollerNoticeItem.getItemNo());
            roller.setCreateTime(new Date());
            roller.setCreateName(loginUser.getNickName());
            roller.setPlateStats(RollerStatus.USABLE.getCode());
            roller.setRollerItemId(rollerNoticeItem.getId());
            roller.setClosingTime(rollerNoticeItem.getClosingTime());
            roller.setIsEnable(Constant.YES_INT);
            roller.setPurRemark(rollerNoticeItem.getPurRemark());
            this.completeinfo(roller, rollerNotice, rollerNoticeItem);
            if (rollerNoticeItem.getDesignedLifeTime() == null) {
                roller.setDesignedLifetime(new BigDecimal(0));
            }
            if (roller.getUserLifetime() == null) {
                roller.setUserLifetime(new BigDecimal(0));
            }
            roller.setSurplusLifetime(roller.getDesignedLifetime().subtract(roller.getUserLifetime()).setScale(2, 4));
            roller.setSupplyArea(rollerNoticeItem.getSupplyArea());
            roller.setCompanyCode(rollerNoticeItem.getCompanyCode());
            roller.setCompanyName(rollerNoticeItem.getCompanyName());
            roller.setDateUnit("\u79d2");
            this.completeMouldSupAndPur(roller, rollerNotice);
            this.rollerService.addObj(roller);
        }
    }

    private void completeMouldSupAndPur(Roller roller, RollerNotice rollerNotice) {
        roller.setPurCompanyId(rollerNotice.getPurCompanyId());
        roller.setPurCompanyFullName(rollerNotice.getPurCompanyFullName());
        roller.setPurCompanyName(rollerNotice.getPurCompanyName());
        roller.setPurCompanySrmCode(rollerNotice.getPurCompanySrmCode());
        Company plateCompany = this.companyService.queryCompanyBySapCode(rollerNotice.getRollerSupCompanySapCode());
        roller.setPlateSupCompanyId(plateCompany.getId());
        roller.setPlateSupCompanySrmCode(plateCompany.getCompanyCode());
        roller.setPlateSupCompanyName(plateCompany.getCompanyName());
        roller.setPlateSupCompanyFullName(plateCompany.getCompanyFullName());
        roller.setPlateSupCompanySapCode(plateCompany.getCompanySapCode());
        Company conCompany = this.companyService.queryCompanyBySapCode(rollerNotice.getConceiveSupCompanySapCode());
        roller.setConceiveSupCompanyId(conCompany.getId());
        roller.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
        roller.setConceiveSupCompanyName(conCompany.getCompanyName());
        roller.setConceiveSupCompanyFullName(conCompany.getCompanyFullName());
        roller.setConceiveSupCompanySapCode(conCompany.getCompanySapCode());
    }

    private void completeinfo(Roller roller, RollerNotice rollerNotice, RollerNoticeItem rollerNoticeItem) {
        roller.setPlateNo(rollerNoticeItem.getRollerNo());
        roller.setPlateDesc(rollerNoticeItem.getRollerDesc());
        roller.setCompanyCode(rollerNotice.getCompanyCode());
        roller.setCompanyName(rollerNotice.getCompanyName());
        roller.setMaterialCategory(rollerNoticeItem.getMaterialCategory());
        roller.setApplyTime(rollerNotice.getApplyTime());
        roller.setPlateDate(rollerNoticeItem.getClosingTime());
        roller.setRollerNo(rollerNoticeItem.getNoticeNo());
        roller.setRollerItemNo(rollerNoticeItem.getItemNo());
        roller.setDesignedLifetime(rollerNoticeItem.getDesignedLifeTime());
        roller.setDesignCapacity(rollerNoticeItem.getDesignCapacity());
        roller.setActuallyCapacity(rollerNoticeItem.getActuallyCapacity());
        roller.setDateUnit("s");
        roller.setPropertyRightStatus(rollerNotice.getCompanyName());
        String plateNo = roller.getPlateNo();
        RollerExample example = new RollerExample();
        example.createCriteria().andPlateIdLike(plateNo + "___");
        int i = this.mouldInvorker.getRollerService().countByExample(example);
        RollerNoticeItemExample example2 = new RollerNoticeItemExample();
        example2.createCriteria().andRollerIdLike(plateNo + "___");
        int j = this.mouldInvorker.getRollerNoticeItemService().countByExample(example2);
        String id = String.format("%s%03d", plateNo, i + j + 1);
        roller.setPlateId(id);
    }

    @Override
    @Transactional
    @CacheEvict(value={"rollerNoticeItem"}, allEntries=true)
    public void rollerSupConfirm(List<String> ids, final User loginUser) {
        RollerNoticeItemExample example = new RollerNoticeItemExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerNoticeItem> items = this.rollerNoticeItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u901a\u77e5\u5355\u884c");
        RollerNoticeExample example2 = new RollerNoticeExample();
        example2.createCriteria().andIdEqualTo(items.get(0).getNoticeId());
        List notices = this.rollerNoticeService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)notices, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        RollerNotice rollerNotice = (RollerNotice)notices.get(0);
        if (rollerNotice.getBillStatus().equals(RollerBillStatus.ABOLISH.getValue())) {
            throw new CommonException("\u901a\u77e5\u5355:" + rollerNotice.getRollerNo() + "\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
        }
        for (RollerNoticeItem item : items) {
            if (item.getConfirmStatus().equals(RollerConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            if (item.getConfirmStatus().equals(RollerConfirmStatus.ROLLER_SUP_CONFIRM.getCode())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u7248\u8f8a\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            item.setId(item.getId());
            item.setConfirmStatus(RollerConfirmStatus.ROLLER_SUP_CONFIRM.getCode());
            item.setConfirmTime(new Date());
            this.rollerNoticeItemMapper.updateByPrimaryKeySelective(item);
        }
        example.clear();
        example.createCriteria().andNoticeIdEqualTo(((RollerNotice)notices.get(0)).getId());
        List<RollerNoticeItem> list = this.rollerNoticeItemMapper.selectByExample(example);
        Set status = list.stream().map(i -> i.getConfirmStatus()).collect(Collectors.toSet());
        if (status.size() == 1) {
            rollerNotice.setBillStatus(RollerBillStatus.BUILD_ROLLERING.getValue());
        } else {
            rollerNotice.setBillStatus(RollerBillStatus.PART_BUILD_ROLLERING.getValue());
        }
        this.rollerNoticeService.modifyObj(rollerNotice);
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<RollerNoticeItem> itemAxampla = this.queryAllObjByExample(example);
        for (final RollerNoticeItem rollerNoticeItem : itemAxampla) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RollerNoticeItemServiceImpl.this.sendMessagesToPur(loginUser, rollerNoticeItem, RollerBusinessEnum.ROLLER_SUP_CONFIRM.getCode());
                    RollerNoticeItemServiceImpl.this.sendMessagesToConceiveSup(loginUser, rollerNoticeItem, RollerBusinessEnum.ROLLER_SUP_CONFIRM.getCode());
                }
            });
        }
    }

    protected void sendMessagesToRollerSup(User loginUser, RollerNoticeItem data, String businessType) {
        User rollerUser = this.companyUserRefService.queryMainUserOfCompany(data.getRollerSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(rollerUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToConceiveSup(User loginUser, RollerNoticeItem data, String businessType) {
        User conUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(conUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToPur(User loginUser, RollerNoticeItem data, String businessType) {
        User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }
}

