/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.scrap.command;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.scrap.entity.Scrap;
import com.els.base.mould.scrap.utils.ConfirmStatus;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CreateScrapCommand
extends AbstractMouldCommand<String> {
    private List<String> ids;

    public CreateScrapCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)this.ids);
        List moulds = mouldInvorker.getMouldService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177\u4e3b\u6570\u636e!");
        Mould mould = (Mould)moulds.get(0);
        Scrap scrap = new Scrap();
        this.vailad(mould);
        this.init(mould, scrap);
        mouldInvorker.getScrapService().addObj(scrap);
        return null;
    }

    private void init(Mould mould, Scrap scrap) {
        this.basic(mould, scrap);
        Company conCompany = this.getSupCompany();
        scrap.setConceiveSupCompanyId(conCompany.getId());
        scrap.setConceiveSupCompanyName(conCompany.getCompanyName());
        scrap.setConceiveSupCompanyFullName(conCompany.getCompanyFullName());
        scrap.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
        scrap.setConceiveSupCompanySapCode(conCompany.getCompanySapCode());
        scrap.setPurCompanyId(mould.getPurCompanyId());
        scrap.setPurCompanyFullName(mould.getPurCompanyFullName());
        scrap.setPurCompanyName(mould.getPurCompanyName());
        scrap.setPurCompanySrmCode(mould.getCompanyCode());
        scrap.setPurCompanySapCode(mould.getPurCompanySapCode());
        Company mouldCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(mould.getMouldSupCompanySapCode());
        scrap.setMouldSupCompanyId(mouldCompany.getId());
        scrap.setMouldSupCompanyFullName(mouldCompany.getCompanyFullName());
        scrap.setMouldSupCompanyName(mouldCompany.getCompanyName());
        scrap.setMouldSupCompanySrmCode(mouldCompany.getCompanyCode());
        scrap.setMouldSupCompanySapCode(mouldCompany.getCompanySapCode());
    }

    private void basic(Mould mould, Scrap scrap) {
        scrap.setId(UUIDGenerator.generateUUID());
        scrap.setProjectId(ProjectUtils.getProjectId());
        scrap.setScrapNo(UUIDGenerator.generateUUID());
        scrap.setCompanyCode(mould.getCompanyCode());
        scrap.setCompanyName(mould.getCompanyName());
        scrap.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        scrap.setCreateTime(new Date());
        scrap.setMouldId(mould.getMouldId());
        scrap.setMouldNo(mould.getMouldNo());
        scrap.setMouldDesc(mould.getMouldDesc());
        scrap.setMouldStatus(mould.getMouldStatus());
        scrap.setMouldNumber(mould.getMouldNumber());
        scrap.setUsedLifetime(mould.getUsedLifetime());
        scrap.setSurplusLifetime(mould.getOverplusLifetime());
        scrap.setScrapMode(Constant.NO_INT);
        scrap.setIsEnable("N");
        scrap.setReceiveMould(mould.getMouldTime());
        scrap.setDesignedLifetime(mould.getDesignedLifetime());
        scrap.setUsedLifetime(mould.getUsedLifetime());
        scrap.setScrapType("\u62a5\u5e9f");
        scrap.setSendStatus(Constant.NO_INT);
        scrap.setConfirmStatus(ConfirmStatus.NO_CONFIRM.getValue());
        scrap.setPurRemark(mould.getPurRemark());
    }

    private void vailad(Mould mould) {
        Assert.isNotNull((Object)mould, (String)"\u6a21\u5177\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        if (mould.getMouldStatus().equals(MouldStatus.ABLOISH.getCode())) {
            throw new CommonException("\u8be5\u6a21\u5177\u5df2\u62a5\u5e9f\uff0c\u4e0d\u80fd\u751f\u6210\u5355\u636e");
        }
    }
}

