/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.check.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.mould.check.dao.CheckItemMapper;
import com.els.base.mould.check.entity.CheckItem;
import com.els.base.mould.check.entity.CheckItemExample;
import com.els.base.mould.check.service.CheckItemService;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.service.MouldService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCheckItemService")
public class CheckItemServiceImpl
implements CheckItemService {
    @Resource
    protected CheckItemMapper checkItemMapper;
    @Resource
    protected MouldInvorker mouldInvorker;
    @Resource
    protected MouldService mouldService;

    @CacheEvict(value={"checkItem"}, allEntries=true)
    public void addObj(CheckItem t) {
        this.checkItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"checkItem"}, allEntries=true)
    public void addAll(List<CheckItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.checkItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"checkItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.checkItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"checkItem"}, allEntries=true)
    public void deleteByExample(CheckItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.checkItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"checkItem"}, allEntries=true)
    public void modifyObj(CheckItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.checkItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"checkItem"}, keyGenerator="redisKeyGenerator")
    public CheckItem queryObjById(String id) {
        return this.checkItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"checkItem"}, keyGenerator="redisKeyGenerator")
    public List<CheckItem> queryAllObjByExample(CheckItemExample example) {
        return this.checkItemMapper.selectByExample(example);
    }

    @Cacheable(value={"checkItem"}, keyGenerator="redisKeyGenerator")
    public PageView<CheckItem> queryObjByPage(CheckItemExample example) {
        PageView<CheckItem> pageView = example.getPageView();
        pageView.setQueryResult(this.checkItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"checkItem"}, keyGenerator="redisKeyGenerator")
    public List<CheckItem> queryByCheckId(String id) {
        Assert.isNotBlank((String)id, (String)"\u76d8\u70b9\u901a\u77e5\u5355\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        CheckItemExample example = new CheckItemExample();
        example.createCriteria().andCheckIdEqualTo(id);
        return this.checkItemMapper.selectByExample(example);
    }

    @Override
    public void deleteByBillNo(String checkNo) {
        CheckItemExample example = new CheckItemExample();
        example.createCriteria().andBillNoEqualTo(checkNo);
        this.checkItemMapper.deleteByExample(example);
    }
}

