/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.life.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.life.dao.MouldLifeMapper;
import com.els.base.mould.life.entity.MouldLife;
import com.els.base.mould.life.entity.MouldLifeExample;
import com.els.base.mould.life.service.MouldLifeService;
import com.els.base.mould.life.utils.LifeConfirmStatus;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.uuid.UUIDGenerator;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="defaultMouldLifeService")
public class MouldLifeServiceImpl
implements MouldLifeService {
    @Resource
    protected MouldLifeMapper mouldLifeMapper;
    @Resource
    protected MouldService mouldService;

    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void addObj(MouldLife t) {
        this.mouldLifeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void addAll(List<MouldLife> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.mouldLifeMapper.insertBatch(list);
    }

    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldLifeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void deleteByExample(MouldLifeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mouldLifeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void modifyObj(MouldLife t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.mouldLifeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"mouldLife"}, keyGenerator="redisKeyGenerator")
    public MouldLife queryObjById(String id) {
        return this.mouldLifeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"mouldLife"}, keyGenerator="redisKeyGenerator")
    public List<MouldLife> queryAllObjByExample(MouldLifeExample example) {
        return this.mouldLifeMapper.selectByExample(example);
    }

    @Cacheable(value={"mouldLife"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldLife> queryObjByPage(MouldLifeExample example) {
        PageView<MouldLife> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldLifeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public int importExcel(MultipartFile file, List<TitleAndModelKey> titleAndModelKeys, User loginUser, Company currentCompany) throws IOException, Exception {
        List lifes = null;
        lifes = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, MouldLife.class);
        Assert.isNotEmpty((Collection)lifes, (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List distinctClass = lifes.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MouldLife>(Comparator.comparing(o -> o.getMouldId()))), ArrayList::new));
        if (distinctClass.size() != lifes.size()) {
            throw new CommonException("\u540c\u4e00\u6a21\u5177ID\u4e0d\u80fd\u5bfc\u5165\u591a\u6761\u6570\u636e!");
        }
        List mouldLifes = lifes.stream().map(mouldLife -> this.initMouldLife((MouldLife)mouldLife, loginUser, currentCompany)).collect(Collectors.toList());
        List group = Lists.partition(mouldLifes, (int)999);
        for (List list : group) {
            this.addAll(list);
        }
        return mouldLifes.size();
    }

    private void updateMould(List<MouldLife> mouldLifes, List<String> mouldIds) {
        for (String mouldId : mouldIds) {
            MouldLifeExample mouldExample = new MouldLifeExample();
            mouldExample.createCriteria().andMouldIdEqualTo(mouldId).andConfirmStatusEqualTo(Constant.YES_INT);
            List<MouldLife> list2 = this.mouldLifeMapper.selectByExample(mouldExample);
            BigDecimal usedLife = new BigDecimal(0);
            if (CollectionUtils.isNotEmpty(list2)) {
                usedLife = list2.stream().map(MouldLife::getMouldUsed).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            MouldExample example = new MouldExample();
            example.createCriteria().andMouldIdEqualTo(mouldId);
            List moulds = this.mouldService.queryAllObjByExample((IExample)example);
            Mould mould = new Mould();
            mould.setId(((Mould)moulds.get(0)).getId());
            mould.setUsedLifetime(usedLife);
            BigDecimal bigDecimal = ((Mould)moulds.get(0)).getDesignedLifetime();
            BigDecimal scale = bigDecimal.subtract(usedLife).setScale(2, 4);
            mould.setOverplusLifetime(scale);
            this.mouldService.modifyObj(mould);
        }
    }

    private MouldLife initMouldLife(MouldLife mouldLife, User loginUser, Company currentCompany) {
        this.isvalid(mouldLife);
        this.complete(mouldLife, loginUser, currentCompany);
        return mouldLife;
    }

    private void complete(MouldLife mouldLife, User user, Company company) {
        String mouldId = mouldLife.getMouldId();
        MouldLifeExample example = new MouldLifeExample();
        example.createCriteria().andMouldIdEqualTo(mouldLife.getMouldId()).andUsedStartTimeEqualTo(mouldLife.getUsedStartTime()).andUsedEndTimeEqualTo(mouldLife.getUsedEndTime());
        if (this.mouldLifeMapper.countByExample(example) > 0) {
            throw new CommonException("\u540c\u4e00\u6a21\u5177ID\u540c\u4e00\u671f\u95f4\u4e0d\u80fd\u5bfc\u5165\u591a\u6761\u6570\u636e!");
        }
        example.clear();
        example.createCriteria().andMouldIdEqualTo(mouldLife.getMouldId());
        List<MouldLife> list = this.mouldLifeMapper.selectByExample(example);
        for (MouldLife mouldLife2 : list) {
            if (!mouldLife.getUsedStartTime().before(mouldLife2.getUsedStartTime()) && !mouldLife.getUsedStartTime().after(mouldLife2.getUsedEndTime()) || !mouldLife.getUsedEndTime().before(mouldLife2.getUsedStartTime()) && !mouldLife.getUsedEndTime().after(mouldLife2.getUsedEndTime())) {
                throw new CommonException("\u6a21\u5177id\uff1a" + mouldLife.getMouldId() + ",\u5b58\u5728\u91cd\u53e0\u8ba1\u7b97\u533a\u95f4,\u8bf7\u68c0\u67e5\uff01");
            }
            if ((mouldLife2.getUsedStartTime().before(mouldLife.getUsedStartTime()) || mouldLife2.getUsedStartTime().after(mouldLife.getUsedEndTime())) && (mouldLife2.getUsedEndTime().before(mouldLife.getUsedStartTime()) || mouldLife2.getUsedEndTime().after(mouldLife.getUsedEndTime()))) continue;
            throw new CommonException("\u6a21\u5177id\uff1a" + mouldLife.getMouldId() + ",\u5b58\u5728\u91cd\u53e0\u8ba1\u7b97\u533a\u95f4,\u8bf7\u68c0\u67e5\uff01");
        }
        MouldExample mouldExample = new MouldExample();
        mouldExample.createCriteria().andMouldIdEqualTo(mouldId);
        List moulds = this.mouldService.queryAllObjByExample((IExample)mouldExample);
        Assert.isNotEmpty((Collection)moulds, (String)("\u6a21\u5177ID" + mouldId + "\u4e0d\u5b58\u5728,\u8bf7\u5148\u7ef4\u62a4\u6a21\u5177\u4e3b\u6570\u636e\uff01"));
        Mould mould = (Mould)moulds.get(0);
        if (!company.getId().equals(mould.getConceiveSupCompanyId())) {
            throw new CommonException("\u5f53\u524d\u4f9b\u5e94\u5546\u975e\u8be5\u6a21\u5177\u7684\u6301\u6709\u4f9b\u5e94\u5546,\u4e0d\u652f\u6301\u5bfc\u5165\uff01");
        }
        this.completeSupAndPur(mould, mouldLife);
        mouldLife.setMouldNo(mould.getMouldNo());
        mouldLife.setMouldDesc(mould.getMouldDesc());
        mouldLife.setBoardDesc(mould.getBoardDesc());
        mouldLife.setSendStatus(Constant.NO_INT);
        mouldLife.setConfirmStatus(Constant.NO_INT);
        mouldLife.setCavityQuantity(mould.getCavityQuantity());
        mouldLife.setMouldStatus(mould.getMouldStatus());
        mouldLife.setCompanyCode(mould.getCompanyCode());
        mouldLife.setCompanyName(mould.getCompanyName());
        mouldLife.setBoard(mould.getBoard());
        mouldLife.setDesignedLifetime(mould.getDesignedLifetime());
        mouldLife.setApplyTime(mould.getApplyTime());
        mouldLife.setOperateTime(new Date());
        mouldLife.setCreateDate(new Date());
        mouldLife.setCreateUser(user.getNickName());
        mouldLife.setIsEnable(Constant.YES_INT);
    }

    private void completeSupAndPur(Mould mould, MouldLife mouldLife) {
        mouldLife.setPurCompanyFullName(mould.getPurCompanyFullName());
        mouldLife.setPurCompanyId(mould.getPurCompanyId());
        mouldLife.setPurCompanyName(mould.getPurCompanyName());
        mouldLife.setPurCompanySapCode(mould.getPurCompanySapCode());
        mouldLife.setPurCompanySrmCode(mould.getPurCompanySrmCode());
        mouldLife.setConceiveSupCompanyFullName(mould.getConceiveSupCompanyFullName());
        mouldLife.setConceiveSupCompanyId(mould.getConceiveSupCompanyId());
        mouldLife.setConceiveSupCompanyName(mould.getConceiveSupCompanyName());
        mouldLife.setConceiveSupCompanySapCode(mould.getConceiveSupCompanySapCode());
        mouldLife.setConceiveSupCompanySrmCode(mould.getConceiveSupCompanySrmCode());
    }

    private void isvalid(MouldLife mouldLife) {
        Assert.isNotBlank((String)mouldLife.getMouldId(), (String)"\u6a21\u5177ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)mouldLife.getUsedStartTime(), (String)"\u8ba1\u7b97\u671f\u95f4\u4ece\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)mouldLife.getUsedEndTime(), (String)"\u8ba1\u7b97\u671f\u95f4\u81f3\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)mouldLife.getMouldUsed(), (String)"\u672c\u671f\u4f7f\u7528\u6a21\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        int signum = mouldLife.getMouldUsed().signum();
        if (signum < 0) {
            throw new CommonException("\u672c\u671f\u4f7f\u7528\u6a21\u6b21\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (mouldLife.getUsedStartTime().after(mouldLife.getUsedEndTime())) {
            throw new CommonException("\u8ba1\u7b97\u671f\u95f4\u81f3\u4e0d\u80fd\u5c0f\u4e8e\u8ba1\u7b97\u671f\u95f4\u4ece\uff01");
        }
    }

    @Override
    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void modifyMouldLife(MouldLife mouldLife) {
        String id = mouldLife.getId();
        MouldLife life = new MouldLife();
        life.setId(id);
        life.setMouldUsed(mouldLife.getMouldUsed());
        life.setRemark(mouldLife.getRemark());
        life.setOperateTime(new Date());
        this.modifyObj(life);
    }

    @Override
    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void sendToPur(List<String> ids) {
        MouldLifeExample example = new MouldLifeExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldLife> lifes = this.mouldLifeMapper.selectByExample(example);
        List list = lifes.stream().filter(i -> Constant.YES_INT.equals(i.getSendStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u6a21\u5177ID:" + ((MouldLife)list.get(0)).getMouldId() + "\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u518d\u53d1\u9001\uff01");
        }
        MouldLife mouldLife = new MouldLife();
        mouldLife.setSendStatus(Constant.YES_INT);
        mouldLife.setSpareField4(new Date());
        mouldLife.setConfirmStatus(Constant.NO_INT);
        this.mouldLifeMapper.updateByExampleSelective(mouldLife, example);
    }

    @Override
    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void confirmForPur(List<String> ids) {
        MouldLifeExample example = new MouldLifeExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldLife> lifes = this.mouldLifeMapper.selectByExample(example);
        List list = lifes.stream().filter(i -> Constant.YES_INT.equals(i.getConfirmStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u6a21\u5177ID:" + ((MouldLife)list.get(0)).getMouldId() + "\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4\uff01");
        }
        MouldLife mouldLife = new MouldLife();
        mouldLife.setConfirmStatus(Constant.YES_INT);
        this.mouldLifeMapper.updateByExampleSelective(mouldLife, example);
        List<String> mouldIds = lifes.stream().map(i -> i.getMouldId()).distinct().collect(Collectors.toList());
        this.updateMould(lifes, mouldIds);
    }

    @Override
    @CacheEvict(value={"mouldLife"}, allEntries=true)
    public void backForPur(List<String> ids) {
        MouldLifeExample example = new MouldLifeExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldLife> lifes = this.mouldLifeMapper.selectByExample(example);
        List list = lifes.stream().filter(i -> Constant.YES_INT.equals(i.getConfirmStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u6a21\u5177ID:" + ((MouldLife)list.get(0)).getMouldId() + "\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u9000\u56de\uff01");
        }
        MouldLife mouldLife = new MouldLife();
        mouldLife.setConfirmStatus(LifeConfirmStatus.CONFIRM_BACK.getCode());
        mouldLife.setSendStatus(Constant.NO_INT);
        this.mouldLifeMapper.updateByExampleSelective(mouldLife, example);
    }
}

