/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.command;

import com.els.base.company.entity.Company;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.notice.entity.MouldNotice;
import com.els.base.mould.notice.entity.NoticeFormFile;
import com.els.base.mould.notice.entity.NoticeItem;
import com.els.base.mould.notice.entity.NoticeItemExample;
import com.els.base.mould.notice.utils.BillStatus;
import com.els.base.mould.notice.utils.ConfirmStatus;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateCommand
extends AbstractMouldCommand<String> {
    private MouldNotice notice;

    public CreateCommand(MouldNotice notice) {
        this.notice = notice;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valid(this.notice);
        this.complete(this.notice);
        mouldInvorker.getNoticeService().addObj(this.notice);
        List<NoticeItem> items = this.notice.getNoticeItems();
        for (NoticeItem noticeItem : items) {
            mouldInvorker.getNoticeItemService().addObj(noticeItem);
            List<NoticeFormFile> files = noticeItem.getFiles();
            if (!CollectionUtils.isNotEmpty(files)) continue;
            for (NoticeFormFile noticeFormFile : files) {
                mouldInvorker.getFileService().addObj(noticeFormFile);
            }
        }
        return null;
    }

    private void complete(MouldNotice notice) {
        this.completeSupAndPur();
        this.completeinfo();
    }

    private void completeinfo() {
        this.notice.setNoticeNo(UUIDGenerator.generateUUID());
        this.notice.setId(UUIDGenerator.generateUUID());
        this.notice.setProjectId(ProjectUtils.getProjectId());
        this.notice.setBillStatus(BillStatus.BUILD.getCode());
        this.notice.setCreateTime(new Date());
        this.notice.setCreateUserName(this.getPurUser().getNickName());
        this.notice.setMouldConfirmStatus(Constant.NO_INT);
        this.notice.setConceiveConfirmStatus(Constant.NO_INT);
        this.notice.setSendStatus(Constant.NO_INT);
        this.notice.setMouldConfirmStatus(Constant.NO_INT);
        this.notice.setConceiveConfirmStatus(Constant.NO_INT);
        this.notice.setIsEnable(Constant.YES_INT);
        BigDecimal includeTaxAmount = new BigDecimal(0);
        BigDecimal taxAmount = new BigDecimal(0);
        List<NoticeItem> items = this.notice.getNoticeItems();
        for (int j = 0; j < items.size(); ++j) {
            NoticeItem i = items.get(j);
            this.completeSupPur(i);
            this.completein(i, j, includeTaxAmount, taxAmount);
            includeTaxAmount = includeTaxAmount.add(i.getIncludeTaxAmount());
            taxAmount = taxAmount.add(i.getTaxAmount());
            List<NoticeFormFile> files = i.getFiles();
            if (!CollectionUtils.isNotEmpty(files)) continue;
            files.forEach(n -> {
                n.setId(UUIDGenerator.generateUUID());
                n.setNoticeId(this.notice.getId());
                n.setNoticeNo(this.notice.getNoticeNo());
                n.setNoticeItemNo(i.getItemNo());
                n.setUploadDate(new Date());
                n.setUploadUserName(this.getPurUser().getNickName());
                n.setIsEnable(Constant.YES_INT);
            });
        }
        this.notice.setIncludeTaxAmount(includeTaxAmount);
        this.notice.setTaxAmount(taxAmount);
    }

    private void completein(NoticeItem i, int j, BigDecimal includeTaxAmount, BigDecimal taxAmount) {
        i.setId(UUIDGenerator.generateUUID());
        i.setNoticeId(this.notice.getId());
        i.setNoticeNo(this.notice.getNoticeNo());
        String mouldNo = i.getMouldNo();
        MouldExample example = new MouldExample();
        example.createCriteria().andMouldIdLike(mouldNo + "___");
        int k = this.mouldInvorker.getMouldService().countByExample(example);
        NoticeItemExample example2 = new NoticeItemExample();
        example2.createCriteria().andMouldIdLike(mouldNo + "___");
        int m = this.mouldInvorker.getNoticeItemService().countByExample(example2);
        String id = String.format("%s%03d", mouldNo, k + m + j + 1);
        i.setMouldId(id);
        i.setItemNo(UUIDGenerator.generateUUID());
        i.setConfirmStatus(ConfirmStatus.NO_CONFIRM.getCode());
        i.setIsEnable("N");
        if (i.getTaxAmount() == null) {
            i.setTaxAmount(new BigDecimal(0));
        }
        if (i.getMouldQuantity() == null || i.getIncludeTaxPrice() == null) {
            i.setIncludeTaxAmount(new BigDecimal(0));
        } else {
            i.setIncludeTaxAmount(i.getMouldQuantity().multiply(i.getIncludeTaxPrice()).setScale(2, 4));
        }
    }

    private void completeSupPur(NoticeItem i) {
        i.setPurCompanyId(this.notice.getPurCompanyId());
        i.setPurCompanyFullName(this.notice.getPurCompanyFullName());
        i.setPurCompanyName(this.notice.getPurCompanyName());
        i.setPurCompanySrmCode(this.notice.getPurCompanySrmCode());
        i.setMouldSupCompanyId(this.notice.getMouldSupCompanyId());
        i.setMouldSupCompanyName(this.notice.getMouldSupCompanyName());
        i.setMouldSupCompanySrmCode(this.notice.getMouldSupCompanySrmCode());
        i.setMouldSupCompanyFullName(this.notice.getMouldSupCompanyFullName());
        i.setMouldSupCompanySapCode(this.notice.getMouldSupCompanySapCode());
        i.setConceiveSupCompanyFullName(this.notice.getConceiveSupCompanyFullName());
        i.setConceiveSupCompanyId(this.notice.getConceiveSupCompanyId());
        i.setConceiveSupCompanyName(this.notice.getConceiveSupCompanyName());
        i.setConceiveSupCompanySapCode(this.notice.getConceiveSupCompanySapCode());
        i.setConceiveSupCompanySrmCode(this.notice.getConceiveSupCompanySrmCode());
    }

    private void completeSupAndPur() {
        Company purCompany = this.getPurCompany();
        this.notice.setPurCompanyId(purCompany.getId());
        this.notice.setPurCompanyFullName(purCompany.getCompanyFullName());
        this.notice.setPurCompanyName(purCompany.getCompanyName());
        this.notice.setPurCompanySrmCode(purCompany.getCompanyCode());
        Company mouCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.notice.getMouldSupCompanySapCode());
        this.notice.setMouldSupCompanyId(mouCompany.getId());
        this.notice.setMouldSupCompanyName(mouCompany.getCompanyName());
        this.notice.setMouldSupCompanySrmCode(mouCompany.getCompanyCode());
        Company conCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.notice.getConceiveSupCompanySapCode());
        this.notice.setConceiveSupCompanyId(conCompany.getId());
        this.notice.setConceiveSupCompanyName(conCompany.getCompanyName());
        this.notice.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
    }

    private void valid(MouldNotice notice) {
        Assert.isNotBlank((String)notice.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)notice.getMouldSupCompanySapCode(), (String)"\u6a21\u5177\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)notice.getConceiveSupCompanySapCode(), (String)"\u6301\u6709\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        List<NoticeItem> noticeItems = notice.getNoticeItems();
        Assert.isNotEmpty(noticeItems, (String)"\u5f00\u6a21\u901a\u77e5\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        noticeItems.forEach(i -> {
            Assert.isNotBlank((String)i.getMouldNo(), (String)"\u6a21\u5177\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull((Object)i.getMouldQuantity(), (String)"\u5f00\u6a21\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)i.getMouldDesc(), (String)"\u6a21\u5177\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull((Object)i.getRequireMouldDate(), (String)"\u8981\u6c42\u4ea4\u6a21\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        });
    }
}

