/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.notice.command.CreateCommand;
import com.els.base.mould.notice.command.DeleteCommand;
import com.els.base.mould.notice.command.ModifyCommand;
import com.els.base.mould.notice.entity.MouldNotice;
import com.els.base.mould.notice.entity.MouldNoticeExample;
import com.els.base.mould.notice.entity.NoticeFormFile;
import com.els.base.mould.notice.entity.NoticeItem;
import com.els.base.mould.notice.service.MouldNoticeService;
import com.els.base.mould.notice.service.NoticeFormFileService;
import com.els.base.mould.notice.service.NoticeItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
@Controller
@RequestMapping(value={"notice"})
public class MouldNoticeController {
    @Resource
    protected MouldNoticeService noticeService;
    @Resource
    protected MouldInvorker mouldInvorker;
    @Resource
    protected NoticeItemService noticeItemService;
    @Resource
    protected NoticeFormFileService fileService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
    @RequestMapping(value={"service/save"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MouldNotice notice) {
        Assert.isNotNull((Object)notice, (String)"\u5f00\u6a21\u901a\u77e5\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMouldCommand command = null;
        command = StringUtils.isEmpty((String)notice.getId()) ? new CreateCommand(notice) : new ModifyCommand(notice);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteCommand command = new DeleteCommand(ids);
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        com.els.base.auth.entity.User loginUser = SpringSecurityUtils.getLoginUser();
        this.noticeService.abolish(ids, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
    @RequestMapping(value={"service/sendToSup"})
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        com.els.base.auth.entity.User loginUser = SpringSecurityUtils.getLoginUser();
        this.noticeService.sendToSup(ids, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Notice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<MouldNotice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldNoticeExample example = new MouldNoticeExample();
        example.setPageView((PageView<MouldNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.noticeService.queryObjByPage((IExample)example);
        List<MouldNotice> notices = this.getNoticeList(pageData.getQueryResult());
        pageData.setQueryResult(notices);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6a21\u5177\u4f9b\u5e94\u5546\u67e5\u8be2\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Notice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForMouldSup"})
    @ResponseBody
    public ResponseResult<PageView<MouldNotice>> findByPageForMouldSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldNoticeExample example = new MouldNoticeExample();
        example.setPageView((PageView<MouldNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        MouldNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andMouldSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId()).andSendStatusEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.noticeService.queryObjByPage((IExample)example);
        List<MouldNotice> notices = this.getNoticeList(pageData.getQueryResult());
        pageData.setQueryResult(notices);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u63a5\u6536\u4f9b\u5e94\u5546\u67e5\u8be2\u6a21\u5177-\u5f00\u6a21\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Notice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForConSup"})
    @ResponseBody
    public ResponseResult<PageView<MouldNotice>> findByPageForConSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldNoticeExample example = new MouldNoticeExample();
        example.setPageView((PageView<MouldNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        MouldNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId()).andSendStatusEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.noticeService.queryObjByPage((IExample)example);
        List<MouldNotice> notices = this.getNoticeList(pageData.getQueryResult());
        pageData.setQueryResult(notices);
        return ResponseResult.success((Object)pageData);
    }

    private List<MouldNotice> getNoticeList(List<MouldNotice> notices) {
        ArrayList<MouldNotice> noticeTempList = new ArrayList<MouldNotice>();
        if (CollectionUtils.isEmpty(notices)) {
            return noticeTempList;
        }
        for (MouldNotice notice : notices) {
            List<NoticeItem> items = this.noticeItemService.queryByNoticeId(notice.getId());
            for (NoticeItem noticeItem : items) {
                List<NoticeFormFile> formFiles = this.fileService.queryByNoticeItemNo(noticeItem.getItemNo());
                noticeItem.setFiles(formFiles);
            }
            notice.setNoticeItems(items);
            noticeTempList.add(notice);
        }
        return noticeTempList;
    }
}

