/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.relation.command;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.relation.entity.Relation;
import com.els.base.mould.relation.entity.RelationExample;
import java.util.Date;

public class ModifyCommand
extends AbstractMouldCommand<String> {
    private Relation relation;

    public ModifyCommand(Relation relation) {
        this.relation = relation;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valid(this.relation);
        this.complete(this.relation);
        RelationExample example = new RelationExample();
        example.createCriteria().andMouldNoEqualTo(this.relation.getMouldNo()).andMaterialNoEqualTo(this.relation.getMaterialNo()).andIdNotEqualTo(this.relation.getId()).andIsEnableEqualTo("N");
        int i = this.mouldInvorker.getRelationService().countByexample(example);
        if (i > 0) {
            throw new CommonException("\u8be5\u6570\u636e\u5df2\u5b58\u5728,\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0!");
        }
        mouldInvorker.getRelationService().modifyObj(this.relation);
        return null;
    }

    private void complete(Relation relation) {
        relation.setUpdateTime(new Date());
        relation.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
    }

    private void valid(Relation relation) {
        Assert.isNotBlank((String)relation.getMouldNo(), (String)"\u6a21\u5177\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)relation.getMaterialNo(), (String)"\u7269\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
    }
}

