/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.command;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.entity.RollerFormFile;
import com.els.base.mould.roller.entity.RollerNotice;
import com.els.base.mould.roller.entity.RollerNoticeItem;
import com.els.base.mould.roller.entity.RollerNoticeItemExample;
import com.els.base.mould.roller.utlis.RollerConfirmStatus;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ModifyCommand
extends AbstractMouldCommand<String> {
    private RollerNotice rollerNotice;

    public ModifyCommand(RollerNotice rollerNotice) {
        this.rollerNotice = rollerNotice;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valiad(this.rollerNotice);
        this.compele(this.rollerNotice);
        mouldInvorker.getRollerNoticeService().modifyObj(this.rollerNotice);
        RollerNoticeItemExample example = new RollerNoticeItemExample();
        example.createCriteria().andNoticeIdEqualTo(this.rollerNotice.getId());
        List items = mouldInvorker.getRollerNoticeItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)items, (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (RollerNoticeItem rollerNoticeItem : items) {
            mouldInvorker.getRollerNoticeItemService().deleteObjById(rollerNoticeItem.getId());
        }
        for (RollerNoticeItem item : this.rollerNotice.getNoticeItems()) {
            this.init(item);
            this.compelefo(item);
            mouldInvorker.getRollerNoticeItemService().addObj(item);
            if (!CollectionUtils.isNotEmpty(item.getFiles())) continue;
            for (RollerFormFile file : item.getFiles()) {
                mouldInvorker.getRollerFormFileService().addObj(file);
            }
        }
        return null;
    }

    private void init(RollerNoticeItem item) {
        item.setPurCompanyId(this.rollerNotice.getPurCompanyId());
        item.setPurCompanyFullName(this.rollerNotice.getPurCompanyFullName());
        item.setPurCompanyName(this.rollerNotice.getPurCompanyName());
        item.setPurCompanySrmCode(this.rollerNotice.getPurCompanySrmCode());
        item.setRollerSupCompanyId(this.rollerNotice.getRollerSupCompanyId());
        item.setRollerSupCompanyName(this.rollerNotice.getRollerSupCompanyName());
        item.setRollerSupCompanyFullName(this.rollerNotice.getRollerSupCompanyFullName());
        item.setRollerSupCompanySapCode(this.rollerNotice.getRollerSupCompanySapCode());
        item.setRollerSupCompanySrmCode(this.rollerNotice.getRollerSupCompanySrmCode());
        item.setConceiveSupCompanyId(this.rollerNotice.getConceiveSupCompanyId());
        item.setConceiveSupCompanyName(this.rollerNotice.getConceiveSupCompanyName());
        item.setConceiveSupCompanyFullName(this.rollerNotice.getConceiveSupCompanyFullName());
        item.setConceiveSupCompanySapCode(this.rollerNotice.getConceiveSupCompanySapCode());
        item.setConceiveSupCompanySrmCode(this.rollerNotice.getConceiveSupCompanySrmCode());
    }

    private void compelefo(RollerNoticeItem item) {
        item.setId(UUIDGenerator.generateUUID());
        item.setNoticeId(this.rollerNotice.getId());
        item.setNoticeNo(this.rollerNotice.getRollerNo());
        item.setItemNo(UUIDGenerator.generateUUID());
        item.setConfirmStatus(RollerConfirmStatus.NO_CONFIRM.getCode());
        if (this.rollerNotice.getApplyTime() == null) {
            this.rollerNotice.setApplyTime(new Date());
        }
        item.setIsEnable("N");
        List<RollerFormFile> files = item.getFiles();
        if (CollectionUtils.isNotEmpty(files)) {
            files.forEach(i -> {
                i.setId(UUIDGenerator.generateUUID());
                i.setRollerId(this.rollerNotice.getId());
                i.setRollerNo(this.rollerNotice.getRollerNo());
                i.setRollerItemNo(item.getItemNo());
                i.setUploadDate(new Date());
                i.setUploadUserName(this.getPurUser().getNickName());
                i.setIsEnable(Constant.YES_INT);
            });
        }
    }

    private void compele(RollerNotice rollerNotice) {
        Company rollerCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(rollerNotice.getRollerSupCompanySapCode());
        rollerNotice.setRollerSupCompanyId(rollerCompany.getId());
        rollerNotice.setRollerSupCompanyName(rollerCompany.getCompanyName());
        rollerNotice.setRollerSupCompanySrmCode(rollerCompany.getCompanyCode());
        Company conCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(rollerNotice.getConceiveSupCompanySapCode());
        rollerNotice.setConceiveSupCompanyId(conCompany.getId());
        rollerNotice.setConceiveSupCompanyName(conCompany.getCompanyName());
        rollerNotice.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
        rollerNotice.setUpdateTime(new Date());
        rollerNotice.setUpdateUser(this.getPurUser().getNickName());
    }

    private void valiad(RollerNotice rollerNotice) {
        if (Constant.YES_INT.equals(rollerNotice.getSendStatus())) {
            throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001,\u4e0d\u80fd\u4fee\u6539");
        }
        Assert.isNotBlank((String)rollerNotice.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)rollerNotice.getRollerSupCompanySapCode(), (String)"\u5236\u7248\u4f9b\u5e94\u5546SAP#\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)rollerNotice.getConceiveSupCompanySapCode(), (String)"\u63a5\u6536\u4f9b\u5e94\u5546SAP#\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<RollerNoticeItem> noticeItems = rollerNotice.getNoticeItems();
        Assert.isNotEmpty(noticeItems, (String)"\u5236\u7248\u901a\u77e5\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        noticeItems.forEach(n -> {
            Assert.isNotBlank((String)n.getRollerNo(), (String)"\u7248\u8f8a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)n.getRequiredDeliveryTime(), (String)"\u8981\u6c42\u4ea4\u7248\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)n.getPlateQuantity(), (String)"\u5236\u7248\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }
}

