/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.master.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.mould.roller.master.dao.RollerMapper;
import com.els.base.mould.roller.master.entity.Roller;
import com.els.base.mould.roller.master.entity.RollerExample;
import com.els.base.mould.roller.master.service.RollerService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultRollerService")
public class RollerServiceImpl
implements RollerService {
    @Resource
    protected RollerMapper rollerMapper;

    @CacheEvict(value={"roller"}, allEntries=true)
    public void addObj(Roller t) {
        this.rollerMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"roller"}, allEntries=true)
    public void addAll(List<Roller> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.rollerMapper.insertBatch(list);
    }

    @CacheEvict(value={"roller"}, allEntries=true)
    public void deleteObjById(String id) {
        this.rollerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"roller"}, allEntries=true)
    public void deleteByExample(RollerExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.rollerMapper.deleteByExample(example);
    }

    @CacheEvict(value={"roller"}, allEntries=true)
    public void modifyObj(Roller t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.rollerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"roller"}, keyGenerator="redisKeyGenerator")
    public Roller queryObjById(String id) {
        return this.rollerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"roller"}, keyGenerator="redisKeyGenerator")
    public List<Roller> queryAllObjByExample(RollerExample example) {
        return this.rollerMapper.selectByExample(example);
    }

    @Cacheable(value={"roller"}, keyGenerator="redisKeyGenerator")
    public PageView<Roller> queryObjByPage(RollerExample example) {
        PageView<Roller> pageView = example.getPageView();
        pageView.setQueryResult(this.rollerMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"roller"}, keyGenerator="redisKeyGenerator")
    public int countByExample(RollerExample example) {
        return this.rollerMapper.countByExample(example);
    }
}

