/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.service.impl;

import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.roller.dao.RollerNoticeMapper;
import com.els.base.mould.roller.entity.RollerNotice;
import com.els.base.mould.roller.entity.RollerNoticeExample;
import com.els.base.mould.roller.entity.RollerNoticeItem;
import com.els.base.mould.roller.entity.RollerNoticeItemExample;
import com.els.base.mould.roller.service.RollerNoticeItemService;
import com.els.base.mould.roller.service.RollerNoticeService;
import com.els.base.mould.roller.utlis.RollerBillStatus;
import com.els.base.mould.roller.utlis.RollerBusinessEnum;
import com.els.base.mould.roller.utlis.RollerConfirmStatus;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultRollerNoticeService")
public class RollerNoticeServiceImpl
implements RollerNoticeService {
    @Resource
    protected RollerNoticeMapper rollerNoticeMapper;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private RollerNoticeItemService rollerNoticeItemService;

    @CacheEvict(value={"rollerNotice"}, allEntries=true)
    public void addObj(RollerNotice t) {
        this.rollerNoticeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"rollerNotice"}, allEntries=true)
    public void addAll(List<RollerNotice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.rollerNoticeMapper.insertBatch(list);
    }

    @CacheEvict(value={"rollerNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.rollerNoticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"rollerNotice"}, allEntries=true)
    public void deleteByExample(RollerNoticeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.rollerNoticeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"rollerNotice"}, allEntries=true)
    public void modifyObj(RollerNotice t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.rollerNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"rollerNotice"}, keyGenerator="redisKeyGenerator")
    public RollerNotice queryObjById(String id) {
        return this.rollerNoticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"rollerNotice"}, keyGenerator="redisKeyGenerator")
    public List<RollerNotice> queryAllObjByExample(RollerNoticeExample example) {
        return this.rollerNoticeMapper.selectByExample(example);
    }

    @Cacheable(value={"rollerNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<RollerNotice> queryObjByPage(RollerNoticeExample example) {
        PageView<RollerNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.rollerNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"rollerNotice"}, allEntries=true)
    public void sendToSup(List<String> ids, final com.els.base.auth.entity.User loginUser) {
        RollerNoticeExample example = new RollerNoticeExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerNotice> rollerNotices = this.rollerNoticeMapper.selectByExample(example);
        Assert.isNotEmpty(rollerNotices, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        for (RollerNotice rollerNotice : rollerNotices) {
            rollerNotice.setId(rollerNotice.getId());
            rollerNotice.setSendStatus(Constant.YES_INT);
            rollerNotice.setSendTime(new Date());
            this.rollerNoticeMapper.updateByPrimaryKeySelective(rollerNotice);
        }
        List<RollerNotice> noticeList = this.queryAllObjByExample(example);
        for (final RollerNotice rollerNotice : noticeList) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RollerNoticeServiceImpl.this.sendMessagesToRollerSup(loginUser, rollerNotice, RollerBusinessEnum.ROLLER_NOTICE_SEND.getCode());
                    RollerNoticeServiceImpl.this.sendMessagesToConceiveSup(loginUser, rollerNotice, RollerBusinessEnum.ROLLER_NOTICE_SEND.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"rollerNotice"}, allEntries=true)
    public void abolish(List<String> ids, final com.els.base.auth.entity.User loginUser) {
        RollerNoticeExample example = new RollerNoticeExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerNotice> rollerNotices = this.rollerNoticeMapper.selectByExample(example);
        Assert.isNotEmpty(rollerNotices, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        for (RollerNotice rollerNotice : rollerNotices) {
            if (Constant.NO_INT.equals(rollerNotice.getSendStatus())) {
                throw new CommonException("\u5236\u7248\u901a\u77e5\u5355\uff1a" + rollerNotice.getRollerNo() + "\u672a\u53d1\u9001\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
            }
            if (rollerNotice.getBillStatus().equals(RollerBillStatus.ABOLISH.getValue())) {
                throw new CommonException("\u5236\u7248\u901a\u77e5\u5355\uff1a" + rollerNotice.getRollerNo() + "\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u518d\u4f5c\u5e9f");
            }
            RollerNoticeItemExample example2 = new RollerNoticeItemExample();
            example2.createCriteria().andNoticeIdEqualTo(rollerNotice.getId());
            List items = this.rollerNoticeItemService.queryAllObjByExample((IExample)example2);
            for (RollerNoticeItem rollerNoticeItem : items) {
                if (!RollerConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode().equals(rollerNoticeItem.getConfirmStatus())) continue;
                throw new CommonException("\u5355\u53f7:" + rollerNotice.getRollerNo() + "\u542b\u6709\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4\u7684\u884c\u9879\u76ee,\u4e0d\u5141\u8bb8\u4f5c\u5e9f!");
            }
            rollerNotice.setId(rollerNotice.getId());
            rollerNotice.setBillStatus(RollerBillStatus.ABOLISH.getValue());
            this.rollerNoticeMapper.updateByPrimaryKeySelective(rollerNotice);
        }
        List<RollerNotice> noticeList = this.queryAllObjByExample(example);
        for (final RollerNotice rollerNotice : noticeList) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RollerNoticeServiceImpl.this.sendMessagesToRollerSup(loginUser, rollerNotice, RollerBusinessEnum.ROLLER_NOTICE_ABOLISH.getCode());
                    RollerNoticeServiceImpl.this.sendMessagesToConceiveSup(loginUser, rollerNotice, RollerBusinessEnum.ROLLER_NOTICE_ABOLISH.getCode());
                }
            });
        }
    }

    protected void sendMessagesToRollerSup(com.els.base.auth.entity.User loginUser, RollerNotice data, String businessType) {
        User rollerUser = this.companyUserRefService.queryMainUserOfCompany(data.getRollerSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(rollerUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToConceiveSup(com.els.base.auth.entity.User loginUser, RollerNotice data, String businessType) {
        User conUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(conUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }
}

