/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.allot.service.impl;

import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.allot.dao.AllotItemMapper;
import com.els.base.mould.allot.entity.AllotItem;
import com.els.base.mould.allot.entity.AllotItemExample;
import com.els.base.mould.allot.entity.MouldAllot;
import com.els.base.mould.allot.entity.MouldAllotExample;
import com.els.base.mould.allot.service.AllotItemService;
import com.els.base.mould.allot.service.MouldAllotService;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.utils.MouldBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultAllotItemService")
public class AllotItemServiceImpl
implements AllotItemService {
    @Resource
    protected AllotItemMapper allotItemMapper;
    @Resource
    protected MouldService mouldService;
    @Resource
    protected MouldAllotService mouldAllotService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;

    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void addObj(AllotItem t) {
        this.allotItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void addAll(List<AllotItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.allotItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.allotItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void deleteByExample(AllotItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.allotItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void modifyObj(AllotItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.allotItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"allotItem"}, keyGenerator="redisKeyGenerator")
    public AllotItem queryObjById(String id) {
        return this.allotItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"allotItem"}, keyGenerator="redisKeyGenerator")
    public List<AllotItem> queryAllObjByExample(AllotItemExample example) {
        return this.allotItemMapper.selectByExample(example);
    }

    @Cacheable(value={"allotItem"}, keyGenerator="redisKeyGenerator")
    public PageView<AllotItem> queryObjByPage(AllotItemExample example) {
        PageView<AllotItem> pageView = example.getPageView();
        pageView.setQueryResult(this.allotItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void deleteByIds(List<String> ids) {
        AllotItemExample example = new AllotItemExample();
        example.createCriteria().andIdNotIn((List)ids);
        List<AllotItem> items = this.allotItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u8c03\u62e8\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a,\u5220\u9664\u5931\u8d25!");
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<AllotItem> allotItems = this.allotItemMapper.selectByExample(example);
        Assert.isNotEmpty(allotItems, (String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8c03\u62e8\u5355\u884c");
        MouldAllotExample example2 = new MouldAllotExample();
        example2.createCriteria().andAllotNoEqualTo(allotItems.get(0).getAllotNo());
        List allots = this.mouldAllotService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)allots, (String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8c03\u62e8\u5355");
        MouldAllot mouldAllot = (MouldAllot)allots.get(0);
        if (Constant.YES_INT.equals(mouldAllot.getSendStatus())) {
            throw new CommonException("\u8be5\u8c03\u62e8\u5355\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        for (AllotItem item : allotItems) {
            item.setId(item.getId());
            item.setIsEnable(Constant.NO_INT);
            this.allotItemMapper.updateByExampleSelective(item, example);
        }
    }

    @Override
    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void addToPrepure(MouldAllot allot) {
        if (Constant.YES_INT.equals(allot.getSendStatus())) {
            throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0");
        }
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)allot.getIds());
        List moulds = this.mouldService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177\u4e3b\u6570\u636e!");
        this.valid(moulds);
        ArrayList<AllotItem> items = new ArrayList<AllotItem>();
        for (Mould mould : moulds) {
            AllotItem item = new AllotItem();
            BeanUtils.copyProperties((Object)mould, (Object)item);
            item.setBoard(mould.getBoardDesc());
            item.setAllotNo(allot.getAllotNo());
            item.setAllotType(allot.getAllotType());
            item.setItemNo(UUIDGenerator.generateUUID());
            item.setIsEnable(Constant.YES_INT);
            item.setMouldConfirmStatus(Constant.NO_INT);
            item.setConceiveConfirmStatus(Constant.NO_INT);
            items.add(item);
        }
        List<AllotItem> allotItems = allot.getItems();
        if (CollectionUtils.isEmpty(allotItems)) {
            allot.setItems(items);
        } else {
            allotItems.addAll(items);
            allot.setItems(allotItems);
        }
    }

    private void valid(List<Mould> moulds) {
        Set companies = moulds.stream().map(i -> i.getCompanyCode()).collect(Collectors.toSet());
        Set sups = moulds.stream().map(i -> i.getConceiveSupCompanySapCode()).collect(Collectors.toSet());
        if (companies.size() != 1 || sups.size() != 1) {
            throw new CommonException("\u4e0d\u540c\u516c\u53f8\uff08\u6216\u4e0d\u540c\u6301\u6709\u4f9b\u5e94\u5546\uff09\u7684\u6a21\u5177\u4e0d\u80fd\u751f\u6210\u4e00\u5f20\u8c03\u62e8\u5355!");
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void confirmForMouSup(List<String> ids, final com.els.base.auth.entity.User loginUser) {
        AllotItemExample example = new AllotItemExample();
        example.createCriteria().andIdIn((List)ids);
        List<AllotItem> items = this.allotItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u672a\u627e\u5230\u884c\u6570\u636e");
        MouldAllotExample example2 = new MouldAllotExample();
        example2.createCriteria().andAllotNoEqualTo(items.get(0).getAllotNo());
        List allots = this.mouldAllotService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)allots, (String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8c03\u62e8\u5355");
        MouldAllot mouldAllot = (MouldAllot)allots.get(0);
        if (Constant.YES_INT.equals(mouldAllot.getAllotStatus())) {
            throw new CommonException("\u5355\u636e:" + ((MouldAllot)allots.get(0)).getAllotNo() + "\u5df2\u4f5c\u5e9f,\u65e0\u6cd5\u518d\u786e\u8ba4!");
        }
        for (AllotItem item : items) {
            if (Constant.YES_INT.equals(item.getMouldConfirmStatus())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u65e0\u6cd5\u518d\u786e\u8ba4!");
            }
            item.setId(item.getId());
            item.setMouldConfirmStatus(Constant.YES_INT);
            if (item.getReceiveTime() == null) {
                item.setReceiveTime(new Date());
            }
            this.allotItemMapper.updateByPrimaryKeySelective(item);
        }
        for (AllotItem aitem : items) {
            MouldExample example3 = new MouldExample();
            example3.createCriteria().andMouldIdEqualTo(aitem.getMouldId());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example3);
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.USABLE.getCode());
                mould.setConceiveSupCompanyFullName(aitem.getMouldSupCompanyFullName());
                mould.setConceiveSupCompanyId(aitem.getMouldSupCompanyId());
                mould.setConceiveSupCompanyName(aitem.getMouldSupCompanyName());
                mould.setConceiveSupCompanySapCode(aitem.getMouldSupCompanySapCode());
                mould.setConceiveSupCompanySrmCode(aitem.getMouldSupCompanySrmCode());
                this.mouldService.modifyObj(mould);
            }
        }
        List<AllotItem> list = this.queryAllObjByExample(example);
        for (final AllotItem allotItem : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    AllotItemServiceImpl.this.sendMessagesToPur(loginUser, allotItem, MouldBusinessEnum.MOULD_ALLOT_MOU_CONFIRM.getCode());
                    AllotItemServiceImpl.this.sendMessagesToConceiveSup(loginUser, allotItem, MouldBusinessEnum.MOULD_ALLOT_MOU_CONFIRM.getCode());
                }
            });
        }
    }

    protected void sendMessagesToPur(com.els.base.auth.entity.User loginUser, AllotItem data, String businessType) {
        User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToConceiveSup(com.els.base.auth.entity.User loginUser, AllotItem data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToMouldSup(com.els.base.auth.entity.User loginUser, AllotItem data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getMouldSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @Transactional
    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void confirmForConSup(List<String> ids, final com.els.base.auth.entity.User loginUser) {
        AllotItemExample example = new AllotItemExample();
        example.createCriteria().andIdIn((List)ids);
        List<AllotItem> items = this.allotItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u672a\u627e\u5230\u884c\u6570\u636e");
        MouldAllotExample example2 = new MouldAllotExample();
        example2.createCriteria().andAllotNoEqualTo(items.get(0).getAllotNo());
        List allots = this.mouldAllotService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)allots, (String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8c03\u62e8\u5355");
        MouldAllot mouldAllot = (MouldAllot)allots.get(0);
        if (Constant.YES_INT.equals(mouldAllot.getAllotStatus())) {
            throw new CommonException("\u5355\u636e:" + ((MouldAllot)allots.get(0)).getAllotNo() + "\u5df2\u4f5c\u5e9f,\u65e0\u6cd5\u518d\u786e\u8ba4!");
        }
        for (AllotItem item : items) {
            if (Constant.YES_INT.equals(item.getMouldConfirmStatus())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            if (Constant.YES_INT.equals(item.getConceiveConfirmStatus())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u8c03\u51fa\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            item.setId(item.getId());
            item.setConceiveConfirmStatus(Constant.YES_INT);
            if (item.getRequireSendTime() == null) {
                item.setRequireSendTime(new Date());
            }
            if (item.getSendTime() == null) {
                item.setSendTime(new Date());
            }
            this.allotItemMapper.updateByPrimaryKeySelective(item);
        }
        for (AllotItem aitem : items) {
            MouldExample example3 = new MouldExample();
            example3.createCriteria().andMouldIdEqualTo(aitem.getMouldId());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example3);
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.MOVE.getCode());
                this.mouldService.modifyObj(mould);
            }
        }
        List<AllotItem> list = this.queryAllObjByExample(example);
        for (final AllotItem allotItem : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    AllotItemServiceImpl.this.sendMessagesToPur(loginUser, allotItem, MouldBusinessEnum.MOULD_ALLOT_CON_CONFIRM.getCode());
                    AllotItemServiceImpl.this.sendMessagesToMouldSup(loginUser, allotItem, MouldBusinessEnum.MOULD_ALLOT_CON_CONFIRM.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"allotItem"}, allEntries=true)
    public void deleteByAllotNo(String allotNo) {
        AllotItemExample example = new AllotItemExample();
        example.createCriteria().andAllotNoEqualTo(allotNo);
        this.allotItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"allotItem"}, allEntries=true)
    public List<AllotItem> queryObyByAllotNo(String allotNo) {
        AllotItemExample example = new AllotItemExample();
        example.createCriteria().andAllotNoEqualTo(allotNo).andIsEnableEqualTo(Constant.YES_INT);
        return this.allotItemMapper.selectByExample(example);
    }
}

