/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.board.command;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.board.entity.Board;
import com.els.base.mould.board.entity.BoardExample;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
extends AbstractMouldCommand<String> {
    private Board board;

    public CreateCommand(Board board) {
        this.board = board;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valid(this.board);
        this.init(this.board);
        mouldInvorker.getBoardService().addObj(this.board);
        return null;
    }

    private void init(Board board) {
        this.completeSupAndPur();
        this.complete();
    }

    private void completeSupAndPur() {
        Company purCompany = CompanyUtils.currentCompany();
        this.board.setPurCompanyId(purCompany.getId());
        this.board.setPurCompanyFullName(purCompany.getCompanyFullName());
        this.board.setPurCompanyName(purCompany.getCompanyName());
        this.board.setPurCompanySapCode(purCompany.getCompanySapCode());
        this.board.setPurCompanySrmCode(purCompany.getCompanyCode());
        Company supCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.board.getSupCompanySapCode());
        this.board.setSupCompanyId(supCompany.getId());
        this.board.setSupCompanyFullName(supCompany.getCompanyFullName());
        this.board.setSupCompanyName(supCompany.getCompanyName());
        this.board.setSupCompanySapCode(supCompany.getCompanySapCode());
        this.board.setSupCompanySrmCode(supCompany.getCompanyCode());
    }

    private void complete() {
        this.board.setId(UUIDGenerator.generateUUID());
        this.board.setCreateTime(new Date());
        this.board.setCreateName(SpringSecurityUtils.getLoginUser().getNickName());
        this.board.setProjectId(ProjectUtils.getProjectId());
        this.board.setIsEnable(Constant.YES_INT);
        if (StringUtils.isEmpty((String)this.board.getQuantityUnit())) {
            this.board.setQuantityUnit("\u53f0");
        }
        if (this.board.getCenterInterval() == null) {
            this.board.setCenterInterval(new BigDecimal(0));
        }
    }

    private void valid(Board board) {
        BoardExample example = new BoardExample();
        example.createCriteria().andBoardNoEqualTo(board.getBoardNo());
        List list = this.mouldInvorker.getBoardService().queryAllObjByExample((IExample)example);
        if (!list.isEmpty()) {
            throw new CommonException("\u673a\u53f0id\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d");
        }
        Assert.isNotBlank((String)board.getBoardNo(), (String)"\u673a\u53f0id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)board.getQuantity(), (String)"\u673a\u53f0\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)board.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

