/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.board.command;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.utils.Assert;
import com.els.base.mould.board.entity.Board;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import java.math.BigDecimal;
import java.util.Date;

public class ModifyCommand
extends AbstractMouldCommand<String> {
    private Board board;

    public ModifyCommand(Board board) {
        this.board = board;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valid(this.board);
        this.complete(this.board);
        mouldInvorker.getBoardService().modifyObj(this.board);
        return null;
    }

    private void complete(Board board) {
        if (board.getCenterInterval() == null) {
            board.setCenterInterval(new BigDecimal(0));
        }
        board.setUpdateName(SpringSecurityUtils.getLoginUser().getNickName());
        board.setUpdateTime(new Date());
    }

    private void valid(Board board) {
        Assert.isNotBlank((String)board.getBoardNo(), (String)"\u673a\u53f0\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)board.getQuantity(), (String)"\u673a\u53f0\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)board.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

