/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.check.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.check.dao.CheckMapper;
import com.els.base.mould.check.entity.Check;
import com.els.base.mould.check.entity.CheckExample;
import com.els.base.mould.check.entity.CheckItem;
import com.els.base.mould.check.service.CheckItemService;
import com.els.base.mould.check.service.CheckService;
import com.els.base.mould.check.utils.CheckBusinsessEnum;
import com.els.base.mould.check.utils.CheckStatus;
import com.els.base.mould.check.utils.SendStatus;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCheckService")
public class CheckServiceImpl
implements CheckService {
    @Resource
    protected CheckMapper checkMapper;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private MouldService mouldService;
    @Resource
    private MouldInvorker mouldInvorker;
    @Resource
    private CheckItemService checkItemService;

    @CacheEvict(value={"check"}, allEntries=true)
    public void addObj(Check t) {
        this.checkMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"check"}, allEntries=true)
    public void addAll(List<Check> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.checkMapper.insertBatch(list);
    }

    @CacheEvict(value={"check"}, allEntries=true)
    public void deleteObjById(String id) {
        this.checkMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"check"}, allEntries=true)
    public void deleteByExample(CheckExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.checkMapper.deleteByExample(example);
    }

    @CacheEvict(value={"check"}, allEntries=true)
    public void modifyObj(Check t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.checkMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"check"}, keyGenerator="redisKeyGenerator")
    public Check queryObjById(String id) {
        return this.checkMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"check"}, keyGenerator="redisKeyGenerator")
    public List<Check> queryAllObjByExample(CheckExample example) {
        return this.checkMapper.selectByExample(example);
    }

    @Cacheable(value={"check"}, keyGenerator="redisKeyGenerator")
    public PageView<Check> queryObjByPage(CheckExample example) {
        PageView<Check> pageView = example.getPageView();
        pageView.setQueryResult(this.checkMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"check"}, allEntries=true)
    public void invalid(List<String> checkIdList, final User loginUser) {
        CheckExample example = new CheckExample();
        example.createCriteria().andIdIn((List)checkIdList);
        List<Check> checkList = this.checkMapper.selectByExample(example);
        Assert.isNotEmpty(checkList, (String)"\u76d8\u70b9\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        for (Check check : checkList) {
            if (CheckStatus.CON_COMPLETION.getCode().equals(check.getCheckStatus())) {
                throw new CommonException("\u5355\u636e:" + check.getCheckNo() + "\u5df2\u786e\u8ba4\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            }
            if (CheckStatus.REAL_COMPLETION.getCode().equals(check.getCheckStatus())) {
                throw new CommonException("\u5355\u636e:" + check.getCheckNo() + "\u5df2\u5b9e\u76d8\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            }
            if (SendStatus.NOT_SEND.getCode().equals(check.getSendStatus())) {
                throw new CommonException("\u5355\u636e:" + check.getCheckNo() + "\u672a\u53d1\u9001\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            }
            if (CheckStatus.ABOLISH.getCode().equals(check.getCheckStatus())) {
                throw new CommonException("\u5355\u636e:" + check.getCheckNo() + "\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u518d\u4f5c\u5e9f");
            }
            check.setId(check.getId());
            check.setAllotStatus(Constant.YES_INT);
            check.setUpdateName(loginUser.getNickName());
            check.setUpdateTime(new Date());
            check.setCheckStatus(CheckStatus.ABOLISH.getCode());
            this.checkMapper.updateByPrimaryKeySelective(check);
        }
        List<Check> list = this.queryAllObjByExample(example);
        for (final Check check : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CheckServiceImpl.this.sendMessagesToConceiveSup(loginUser, check, CheckBusinsessEnum.CHECK_ABOLISH.getCode());
                }
            });
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"check"}, allEntries=true)
    public void sendToSup(List<String> ids, final User loginUser) {
        CheckExample example = new CheckExample();
        example.createCriteria().andIdIn((List)ids);
        List<Check> checkList = this.checkMapper.selectByExample(example);
        Assert.isNotEmpty(checkList, (String)"\u76d8\u70b9\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        for (Check check : checkList) {
            if (SendStatus.IS_SEND.getCode().equals(check.getSendStatus())) {
                throw new CommonException("\u5355\u636e:" + check.getCheckNo() + "\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u518d\u53d1\u9001");
            }
            check.setId(check.getId());
            check.setSendStatus(SendStatus.IS_SEND.getCode());
            check.setSendTime(new Date());
            check.setUpdateName(loginUser.getNickName());
            check.setUpdateTime(new Date());
            this.checkMapper.updateByPrimaryKeySelective(check);
        }
        List<Check> list = this.queryAllObjByExample(example);
        for (final Check check : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CheckServiceImpl.this.sendMessagesToConceiveSup(loginUser, check, CheckBusinsessEnum.CHECK_SEND.getCode());
                }
            });
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"check"}, allEntries=true)
    public void sendToPurAndMould(List<String> checkIdList, final User loginUser) {
        CheckExample example = new CheckExample();
        example.createCriteria().andIdIn((List)checkIdList);
        List<Check> checkList = this.checkMapper.selectByExample(example);
        Assert.isNotEmpty(checkList, (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u76d8\u70b9\u901a\u77e5\u5355\u7ed3\u679c");
        for (Check check : checkList) {
            if (SendStatus.RESULT_SEND.getCode().equals(check.getSendStatus())) {
                throw new CommonException("\u5355\u53f7\uff1a" + check.getCheckNo() + "\u76d8\u70b9\u7ed3\u679c\u5df2\u53d1\u9001\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u9001");
            }
            if (CheckStatus.ABOLISH.getCode().equals(check.getCheckStatus())) {
                throw new CommonException("\u5355\u53f7\uff1a" + check.getCheckNo() + "\u76d8\u70b9\u901a\u77e5\u5355\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001");
            }
            if (CheckStatus.NOT_STARTED.getCode().equals(check.getCheckStatus())) {
                throw new CommonException("\u5355\u53f7\uff1a" + check.getCheckNo() + "\u76d8\u70b9\u672a\u5f00\u59cb\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001");
            }
            check.setId(check.getId());
            check.setSendStatus(SendStatus.RESULT_SEND.getCode());
            check.setCheckStatus(CheckStatus.REAL_COMPLETION.getCode());
            this.checkMapper.updateByPrimaryKeySelective(check);
        }
        List<Check> list = this.queryAllObjByExample(example);
        for (final Check check : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CheckServiceImpl.this.sendMessagesToPur(loginUser, check, CheckBusinsessEnum.CHECK_RESULT_SEND.getCode());
                }
            });
        }
    }

    protected void sendMessagesToPur(User loginUser, Check data, String businessType) {
        com.els.base.core.entity.user.User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToMouldSup(User loginUser, Check data, String businessType) {
        com.els.base.core.entity.user.User mouldUser = this.companyUserRefService.queryMainUserOfCompany(data.getMouldSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(mouldUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToConceiveSup(User loginUser, Check check, String businessType) {
        com.els.base.core.entity.user.User supUser = this.companyUserRefService.queryMainUserOfCompany(check.getConceiveSupCompanyId());
        Message message = Message.init((Object)check).setBusinessTypeCode(businessType).setCompanyCode(check.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @Transactional
    @CacheEvict(value={"check"}, allEntries=true)
    public void confirmForConceiveSup(List<String> checkIdList, final User loginUser, Company purCompany) {
        CheckExample example = new CheckExample();
        example.createCriteria().andIdIn((List)checkIdList);
        List<Check> ids = this.checkMapper.selectByExample(example);
        Assert.isNotEmpty(ids, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76d8\u70b9\u901a\u77e5\u5355");
        for (Check check : ids) {
            if (!CheckStatus.NOT_STARTED.getCode().equals(check.getCheckStatus())) {
                throw new CommonException("\u53ea\u6709\u672a\u5f00\u59cb\u7684\u76d8\u70b9\u5355\u624d\u5141\u8bb8\u786e\u8ba4");
            }
            check.setId(check.getId());
            check.setConfirmTime(new Date());
            check.setCheckStatus(CheckStatus.STARTED.getCode());
            check.setCheckTime(new Date());
            this.checkMapper.updateByPrimaryKeySelective(check);
        }
        List<Check> list = this.queryAllObjByExample(example);
        for (final Check check : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CheckServiceImpl.this.sendMessagesToPur(loginUser, check, CheckBusinsessEnum.CHECK_SUP_CONFIRM.getCode());
                }
            });
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"check"}, allEntries=true)
    public void createCheckData(List<String> ids, Company currentCompany, User loginUser) {
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)ids);
        List moulds = this.mouldService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177\u4e3b\u6570\u636e!");
        this.check(moulds);
        moulds = moulds.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Mould>(Comparator.comparing(Mould::getConceiveSupCompanySapCode))), ArrayList::new));
        for (Mould mould : moulds) {
            String sapCode = mould.getConceiveSupCompanySapCode();
            Check check = new Check();
            BeanUtils.copyProperties((Object)mould, (Object)check);
            this.camplete(mould, currentCompany, loginUser, check);
            example.clear();
            example.createCriteria().andConceiveSupCompanySapCodeEqualTo(sapCode).andMouldStatusNotEqualTo(MouldStatus.ABLOISH.getCode());
            List mouldList = this.mouldService.queryAllObjByExample((IExample)example);
            ArrayList<CheckItem> items = new ArrayList<CheckItem>();
            for (Mould mou : mouldList) {
                CheckItem checkItem = new CheckItem();
                BeanUtils.copyProperties((Object)mou, (Object)checkItem);
                checkItem.setPurRemark(null);
                checkItem.setId(UUIDGenerator.generateUUID());
                checkItem.setCheckId(check.getId());
                checkItem.setBillNo(check.getCheckNo());
                checkItem.setItemNo(UUIDGenerator.generateUUID());
                checkItem.setIsEnable("N");
                items.add(checkItem);
            }
            check.setCheckItem(items);
            this.insert(check);
        }
    }

    private void check(List<Mould> moulds) {
        for (Mould mould : moulds) {
            if (!MouldStatus.ABLOISH.getCode().equals(mould.getMouldStatus())) continue;
            throw new CommonException("\u5df2\u7ecf\u62a5\u5e9f\u7684\u6a21\u5177\u4e0d\u80fd\u751f\u6210\u76d8\u70b9\u901a\u77e5\u5355!");
        }
    }

    private void camplete(Mould mould, Company purCompany, User loginUser, Check check) {
        check.setId(UUIDGenerator.generateUUID());
        check.setCheckNo(UUIDGenerator.generateUUID());
        check.setProjectId(ProjectUtils.getProjectId());
        check.setCreateUserName(loginUser.getNickName());
        check.setCreateTime(new Date());
        check.setIsEnable(Constant.YES_INT);
        check.setSendStatus(SendStatus.NOT_SEND.getCode());
        check.setCheckStatus(CheckStatus.NOT_STARTED.getCode());
        check.setBillType(CheckBusinsessEnum.BILL_TYPE.getCode());
        check.setAllotStatus(Constant.NO_INT);
        check.setPurRemark(null);
        check.setPurCompanyId(purCompany.getId());
        check.setPurCompanyFullName(purCompany.getCompanyFullName());
        check.setPurCompanyName(purCompany.getCompanyName());
        check.setPurCompanySrmCode(purCompany.getCompanyCode());
        check.setMouldSupCompanyId(mould.getMouldSupCompanyId());
        check.setMouldSupCompanyName(mould.getMouldSupCompanyName());
        check.setMouldSupCompanySrmCode(mould.getMouldSupCompanySrmCode());
        check.setMouldSupCompanyFullName(mould.getMouldSupCompanyFullName());
        check.setMouldSupCompanySapCode(mould.getMouldSupCompanySapCode());
        check.setConceiveSupCompanyId(mould.getConceiveSupCompanyId());
        check.setConceiveSupCompanyFullName(mould.getConceiveSupCompanyFullName());
        check.setConceiveSupCompanyName(mould.getConceiveSupCompanyName());
        check.setConceiveSupCompanySapCode(mould.getConceiveSupCompanySapCode());
        check.setConceiveSupCompanySrmCode(mould.getConceiveSupCompanySrmCode());
    }

    @Override
    @CacheEvict(value={"check"}, allEntries=true)
    public void insert(Check check) {
        Assert.isNotEmpty(check.getCheckItem(), (String)"\u76d8\u70b9\u901a\u77e5\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        String sapCode = check.getConceiveSupCompanySapCode();
        CheckExample example = new CheckExample();
        example.createCriteria().andConceiveSupCompanySapCodeEqualTo(sapCode).andCheckStatusNotEqualTo(CheckStatus.CON_COMPLETION.getCode()).andCheckStatusNotEqualTo(CheckStatus.ABOLISH.getCode()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.checkMapper.countByExample(example) > 0) {
            throw new CommonException("\u4f9b\u5e94\u5546[" + check.getConceiveSupCompanyName() + "]\u5b58\u5728\u76d8\u70b9\u672a\u5b8c\u6210\u7684\u5355\u636e,\u8bf7\u5148\u76d8\u70b9\u8be5\u5355\u636e\uff01");
        }
        this.addObj(check);
        this.checkItemService.addAll(check.getCheckItem());
    }
}

