/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.life.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.life.dao.MouldLifeSapMapper;
import com.els.base.mould.life.entity.MouldLife;
import com.els.base.mould.life.entity.MouldLifeExample;
import com.els.base.mould.life.entity.MouldLifeSap;
import com.els.base.mould.life.entity.MouldLifeSapExample;
import com.els.base.mould.life.sap.ZSRMRFCSHSL2;
import com.els.base.mould.life.service.LifeSapService;
import com.els.base.mould.life.service.MouldLifeSapService;
import com.els.base.mould.life.service.MouldLifeService;
import com.els.base.mould.life.utils.SapException;
import com.els.base.mould.relation.entity.Relation;
import com.els.base.mould.relation.entity.RelationExample;
import com.els.base.mould.relation.service.RelationService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMouldLifeSapService")
public class MouldLifeSapServiceImpl
implements MouldLifeSapService {
    @Resource
    protected MouldLifeSapMapper mouldLifeSapMapper;
    @Resource
    protected RelationService relationService;
    @Resource
    protected MouldLifeService mouldLifeService;
    @Resource
    protected LifeSapService lifeSapService;

    @CacheEvict(value={"mouldLifeSap"}, allEntries=true)
    public void addObj(MouldLifeSap t) {
        this.mouldLifeSapMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"mouldLifeSap"}, allEntries=true)
    public void addAll(List<MouldLifeSap> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.mouldLifeSapMapper.insertBatch(list);
    }

    @CacheEvict(value={"mouldLifeSap"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldLifeSapMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"mouldLifeSap"}, allEntries=true)
    public void deleteByExample(MouldLifeSapExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mouldLifeSapMapper.deleteByExample(example);
    }

    @CacheEvict(value={"mouldLifeSap"}, allEntries=true)
    public void modifyObj(MouldLifeSap t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.mouldLifeSapMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"mouldLifeSap"}, keyGenerator="redisKeyGenerator")
    public MouldLifeSap queryObjById(String id) {
        return this.mouldLifeSapMapper.selectByPrimaryKey(id);
    }

    public List<MouldLifeSap> queryAllObjByExample(MouldLifeSapExample example) {
        return this.mouldLifeSapMapper.selectByExample(example);
    }

    public PageView<MouldLifeSap> queryObjByPage(MouldLifeSapExample example) {
        PageView<MouldLifeSap> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldLifeSapMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    public void insert(List<String> ids, User user) {
        MouldLifeExample example = new MouldLifeExample();
        example.createCriteria().andIdIn((List)ids);
        List lifes = this.mouldLifeService.queryAllObjByExample((IExample)example);
        List distinctLifes = lifes.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MouldLife>(Comparator.comparing(o -> o.getMouldNo() + o.getUsedStartTime() + o.getUsedEndTime() + o.getConceiveSupCompanySapCode()))), ArrayList::new));
        ArrayList<MouldLifeSap> saps = new ArrayList<MouldLifeSap>();
        for (MouldLife mouldLife : distinctLifes) {
            ArrayList<ZSRMRFCSHSL2> data = new ArrayList<ZSRMRFCSHSL2>();
            RelationExample example2 = new RelationExample();
            example2.createCriteria().andMouldNoEqualTo(mouldLife.getMouldNo()).andIsEnableEqualTo("N");
            List relations = this.relationService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)relations, (String)("\u6a21\u5177\u7f16\u53f7:" + mouldLife.getMouldNo() + ",\u672a\u5728\u6a21\u5177\u7269\u6599\u5173\u7cfb\u8868\u7ef4\u62a4,\u8bf7\u5148\u7ef4\u62a4\uff01"));
            BigDecimal reduce = new BigDecimal(0);
            String startTime = DateFormatUtils.format((Date)mouldLife.getUsedStartTime(), (String)"yyyy-MM-dd");
            String endTime = DateFormatUtils.format((Date)mouldLife.getUsedEndTime(), (String)"yyyy-MM-dd");
            for (Relation relation : relations) {
                List<ZSRMRFCSHSL2> items;
                String sapCode = mouldLife.getConceiveSupCompanySapCode();
                String usedStartTime = startTime;
                String usedEndTime = endTime;
                MouldLifeSapExample sapExample = new MouldLifeSapExample();
                sapExample.createCriteria().andMouldNoEqualTo(mouldLife.getMouldNo()).andSupCompanySapCodeEqualTo(mouldLife.getConceiveSupCompanySapCode()).andUsedEndTimeEqualTo(endTime).andUsedStartTimeEqualTo(startTime);
                List<MouldLifeSap> list = this.queryAllObjByExample(sapExample);
                if (CollectionUtils.isNotEmpty(list)) {
                    this.deleteByExample(sapExample);
                }
                if (CollectionUtils.isEmpty(items = this.lifeSapService.importBySap(relation.getMaterialNo(), sapCode, usedStartTime, usedEndTime))) continue;
                data.addAll(items);
                BigDecimal reduce2 = items.stream().map(i -> i.getMENGE()).reduce(BigDecimal.ZERO, BigDecimal::add);
                reduce = reduce.add(reduce2);
            }
            if (lifes.size() == 1 && CollectionUtils.isEmpty(data)) {
                throw new SapException("SAP\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\u7a7a!");
            }
            if (!CollectionUtils.isNotEmpty(data)) continue;
            MouldLifeSap lifeSap = this.complete((ZSRMRFCSHSL2)data.get(0), mouldLife, user, reduce, startTime, endTime);
            this.addObj(lifeSap);
            saps.add(lifeSap);
        }
        if (CollectionUtils.isEmpty(saps)) {
            throw new SapException("SAP\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\u7a7a!");
        }
    }

    private MouldLifeSap complete(ZSRMRFCSHSL2 i, MouldLife mouldLife, User user, BigDecimal reduce, String startTime, String endTime) {
        MouldLifeSap lifeSap = new MouldLifeSap();
        this.completePurAndSup(mouldLife, lifeSap);
        lifeSap.setIsEnable(Constant.YES_INT);
        lifeSap.setCreateTime(new Date());
        lifeSap.setUsedStartTime(startTime);
        lifeSap.setUsedEndTime(endTime);
        lifeSap.setCreateUser(user.getNickName());
        lifeSap.setMouldNo(mouldLife.getMouldNo());
        lifeSap.setMouldDesc(mouldLife.getMouldDesc());
        lifeSap.setReceiveQuantity(reduce);
        lifeSap.setQuantityUnit(i.getMEINS());
        return lifeSap;
    }

    private void completePurAndSup(MouldLife mouldLife, MouldLifeSap lifeSap) {
        lifeSap.setPurCompanyId(mouldLife.getPurCompanyId());
        lifeSap.setPurCompanyFullName(mouldLife.getPurCompanyFullName());
        lifeSap.setPurCompanyName(mouldLife.getPurCompanyName());
        lifeSap.setPurCompanySapCode(mouldLife.getPurCompanySapCode());
        lifeSap.setPurCompanySrmCode(mouldLife.getPurCompanySrmCode());
        lifeSap.setSupCompanyFullName(mouldLife.getConceiveSupCompanyFullName());
        lifeSap.setSupCompanyId(mouldLife.getConceiveSupCompanyId());
        lifeSap.setSupCompanyName(mouldLife.getConceiveSupCompanyName());
        lifeSap.setSupCompanySapCode(mouldLife.getConceiveSupCompanySapCode());
        lifeSap.setSupCompanySrmCode(mouldLife.getConceiveSupCompanySrmCode());
    }
}

