/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.command.CreateCommand;
import com.els.base.mould.master.command.ModifyCommand;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.ExcelFileData;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u6a21\u5177\u4e3b\u6570\u636e")
@Controller
@RequestMapping(value={"mould"})
public class MouldController {
    @Resource
    protected MouldService mouldService;
    @Resource
    protected MouldInvorker mouldInvorker;

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/save"})
    @ResponseBody
    public ResponseResult<String> save(@RequestBody Mould mould) {
        Assert.isNotNull((Object)mould, (String)"\u6a21\u5177\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMouldCommand command = null;
        command = StringUtils.isEmpty((String)mould.getId()) ? new CreateCommand(mould) : new ModifyCommand(mould);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)ids);
        this.mouldService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<Mould> findDetailById(@RequestBody(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        Mould mould = (Mould)this.mouldService.queryObjById(id);
        return ResponseResult.success((Object)mould);
    }

    @ApiOperation(value="\u5bfc\u51faExcel\u6a21\u677f", httpMethod="POST")
    @RequestMapping(value={"service/exportToExcel"})
    @ResponseBody
    public void exportToExcel(HttpServletResponse response) throws Exception {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u6a21\u5177\u4e3b\u6570\u636eExcel\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"\u6a21\u5177\u4e3b\u6570\u636eExcel\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
    }

    private List<TitleAndModelKey> createExcelHeaderColumn() {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setDateFormat("yyyyMMdd");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546SAP\u7f16\u53f7(\u5fc5\u586b)", (String)"conceiveSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546\u540d\u79f0(\u5fc5\u586b)", (String)"conceiveSupCompanyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7(\u5fc5\u586b)", (String)"mouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0(\u5fc5\u586b)", (String)"mouldDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5e8f\u53f7(\u5fc5\u586b)", (String)"mouldNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u65e5\u4ea7\u80fd(\u5fc5\u586b)", (String)"designCapacity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u65b9\u516c\u53f8\u4ee3\u7801(\u5fc5\u586b)", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u65b9\u516c\u53f8\u540d\u79f0(\u5fc5\u586b)", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u89c4\u683c(\u5fc5\u586b)", (String)"mouldSpecifications"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e2d\u5fc3\u8ddd(\u5fc5\u586b)", (String)"centerInterval"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51b7/\u70ed\u6d41\u9053", (String)"passageway"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8154\u6570(\u5fc5\u586b)", (String)"cavityQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4f9b\u5e94\u5546SAP\u7f16\u53f7(\u5fc5\u586b)", (String)"mouldSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4f9b\u5e94\u5546\u540d\u79f0(\u5fc5\u586b)", (String)"mouldSupCompanyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u54c1\u7c7b", (String)"materialType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u6750\u8d28", (String)"mouldQuality"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u673a\u53f0\u7f16\u7801", (String)"board"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u673a\u53f0\u63cf\u8ff0", (String)"boardDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5305\u6750\u6750\u8d28", (String)"concertQuality"));
        TitleAndModelKey applyTime = ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bf7\u65f6\u95f4(YYYYMMDD)", (String)"applyTime");
        applyTime.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKeys.add(applyTime);
        TitleAndModelKey mouldTime = ExcelUtils.createTitleAndModelKey((String)"\u5f00\u6a21\u65f6\u95f4(YYYYMMDD)", (String)"mouldTime");
        mouldTime.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKeys.add(mouldTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9002\u7528\u74f6\u578b", (String)"bottleType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u74f6\u578b\u63cf\u8ff0", (String)"bottleDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u5bff\u547d", (String)"designedLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u53f7", (String)"mouldMark"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165Excel", httpMethod="POST")
    @RequestMapping(value={"service/importFromExcel"})
    @ResponseBody
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
        int i = 0;
        try {
            i = this.mouldService.importExcel(file, titleAndModelKeys, SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany());
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage());
        }
        return ResponseResult.success((Object)("\u6210\u529f\u5bfc\u5165" + i + "\u6761\u8bb0\u5f55!"));
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301xls");
        }
        return file;
    }

    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        MouldExample example = new MouldExample();
        example.setOrderByClause("CREATE_TIME DESC");
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        }
        List moulds = null;
        if (CollectionUtils.isEmpty(ids)) {
            example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
            moulds = this.mouldService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)moulds, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andIdIn((List)ids);
            moulds = this.mouldService.queryAllObjByExample((IExample)example);
        }
        for (Mould mould : moulds) {
            if (mould.getMouldStatus() == 0) {
                mould.setMouldSupRemark("\u62a5\u5e9f");
            }
            if (mould.getMouldStatus() == 1) {
                mould.setMouldSupRemark("\u53ef\u7528");
            }
            if (mould.getMouldStatus() == 2) {
                mould.setMouldSupRemark("\u8fc1\u79fb\u4e2d");
            }
            if (mould.getMouldStatus() == 4) {
                mould.setMouldSupRemark("\u505c\u7528");
            }
            if (mould.getMouldStatus() == 5) {
                mould.setMouldSupRemark("\u76d8\u4e8f");
            }
            if (mould.getMouldStatus() != 3) continue;
            mould.setMouldSupRemark("\u7ef4\u4fee\u4e2d");
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown((Mould)moulds.get(0));
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, moulds, "\u6a21\u5177\u4e3b\u6570\u636e", "\u6a21\u5177\u4e3b\u6570\u636e", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown(Mould mould) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"mouldDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u72b6\u6001", (String)"MouldSupRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177ID", (String)"mouldId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u89c4\u683c", (String)"mouldSpecifications"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5e8f\u53f7", (String)"mouldNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u6750\u8d28", (String)"mouldQuality"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u53f7", (String)"mouldMark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51b7/\u70ed\u6d41\u9053", (String)"passageway"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u540d\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u54c1\u7c7b", (String)"materialType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u673a\u53f0\u7f16\u7801", (String)"board"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u673a\u53f0\u63cf\u8ff0", (String)"boardDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8154\u6570", (String)"cavityQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5305\u6750\u6750\u8d28", (String)"concertQuality"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4f9b\u5e94\u5546SAP#", (String)"mouldSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4f9b\u5e94\u5546\u540d\u79f0", (String)"mouldSupCompanyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u6a21\u901a\u77e5\u5355\u53f7", (String)"mouldNoticeNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u6a21\u901a\u77e5\u5355\u884c\u53f7", (String)"mouldNoticeItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bf7\u65f6\u95f4", (String)"applyTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u6a21\u65f6\u95f4", (String)"mouldTime"));
        if (!CompanyUtils.currentCompany().getId().equals(mould.getConceiveSupCompanyId())) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546SAP#", (String)"conceiveSupCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546\u540d\u79f0", (String)"conceiveSupCompanyFullName"));
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u5bff\u547d", (String)"designedLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u4f7f\u7528\u5bff\u547d", (String)"usedLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5269\u4f59\u5bff\u547d", (String)"overplusLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b89\u89c4\u53ca\u73af\u4fdd\u5f71\u54cd", (String)"influence"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u8fd1\u7ef4\u4fee\u65f6\u95f4", (String)"recentMaintenanceDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0a\u6b21\u76d8\u70b9\u65f6\u95f4", (String)"lastCountDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62a5\u5e9f\u65f6\u95f4", (String)"abolishDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u65e7\u6a21\u5177\u7f16\u53f7", (String)"oldMouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u957f\u5bbd\u9ad8", (String)"volume"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91cd\u91cf", (String)"height"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e2d\u5fc3\u8ddd", (String)"centerInterval"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u533a\u57df", (String)"supplyArea"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u65e5\u4ea7\u80fd", (String)"designCapacity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u65e5\u4ea7\u80fd", (String)"actuallyCapacity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5468\u671f\u65f6\u95f4", (String)"cycleDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4\u5355\u4f4d", (String)"timeUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9002\u7528\u74f6\u578b", (String)"bottleType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u74f6\u578b\u63cf\u8ff0", (String)"bottleDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u6a21\u5177\u7cbe\u5ea6\u7b49\u7ea7", (String)"designAccuracyClass"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u6a21\u5177\u7cbe\u5ea6\u7b49\u7ea7", (String)"actuallyAccuracyClass"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4ea7\u6743\u72b6\u6001", (String)"propertyRight"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"purRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4\u6233", (String)"createTime"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6a21\u5177\u4e3b\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Mould", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Mould>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldExample example = new MouldExample();
        example.setPageView((PageView<Mould>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mouldService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6a21\u5177\u4e3b\u6570\u636e(\u5305\u6750\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Mould", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForConceive"})
    @ResponseBody
    public ResponseResult<PageView<Mould>> findByPageForConceive(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldExample example = new MouldExample();
        example.setPageView((PageView<Mould>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mouldService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

