/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.board.entity.Board;
import com.els.base.mould.board.entity.BoardExample;
import com.els.base.mould.board.service.BoardService;
import com.els.base.mould.master.dao.MouldMapper;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.notice.entity.NoticeItemExample;
import com.els.base.mould.notice.service.NoticeItemService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.service.OrganizationService;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="defaultMouldService")
public class MouldServiceImpl
implements MouldService {
    @Resource
    protected MouldMapper mouldMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected OrganizationService organizationService;
    @Resource
    protected BoardService boardService;
    @Resource
    protected NoticeItemService noticeItemService;

    @CacheEvict(value={"mould"}, allEntries=true)
    public void addObj(Mould t) {
        this.mouldMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"mould"}, allEntries=true)
    public void addAll(List<Mould> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.mouldMapper.insertBatch(list);
    }

    @CacheEvict(value={"mould"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mould"}, allEntries=true)
    public void deleteByExample(MouldExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mouldMapper.deleteByExample(example);
    }

    @CacheEvict(value={"mould"}, allEntries=true)
    public void modifyObj(Mould t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.mouldMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"mould"}, keyGenerator="redisKeyGenerator")
    public Mould queryObjById(String id) {
        return this.mouldMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"mould"}, keyGenerator="redisKeyGenerator")
    public List<Mould> queryAllObjByExample(MouldExample example) {
        return this.mouldMapper.selectByExample(example);
    }

    @Cacheable(value={"mould"}, keyGenerator="redisKeyGenerator")
    public PageView<Mould> queryObjByPage(MouldExample example) {
        PageView<Mould> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"mould"}, keyGenerator="redisKeyGenerator")
    public int countByExample(MouldExample example) {
        return this.mouldMapper.countByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"mould"}, allEntries=true)
    public int importExcel(MultipartFile file, List<TitleAndModelKey> titleAndModelKeys, User user, Company purCompany) throws Exception {
        List moulds = null;
        moulds = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Mould.class);
        Assert.isNotEmpty((Collection)moulds, (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (int i = 0; i < moulds.size(); ++i) {
            this.valid((Mould)moulds.get(i));
            this.completeSup((Mould)moulds.get(i));
            this.completeDemand((Mould)moulds.get(i), purCompany, ProjectUtils.getProjectId(), user);
            String mouldNo = ((Mould)moulds.get(i)).getMouldNo();
            MouldExample example = new MouldExample();
            example.createCriteria().andMouldIdLike(mouldNo + "___");
            int j = this.mouldMapper.countByExample(example);
            NoticeItemExample example2 = new NoticeItemExample();
            example2.createCriteria().andMouldIdLike(mouldNo + "___");
            int k = this.noticeItemService.countByExample(example2);
            String id = null;
            id = i == 0 ? String.format("%s%03d", mouldNo, k + j + i + 1) : String.format("%s%03d", mouldNo, k + j + 1);
            ((Mould)moulds.get(i)).setMouldId(id);
            this.addObj((Mould)moulds.get(i));
        }
        return moulds.size();
    }

    private void completeSup(Mould mould) {
        Company mouCompany = this.companyService.queryCompanyBySapCode(mould.getMouldSupCompanySapCode());
        Assert.isNotNull((Object)mouCompany, (String)("\u4f9b\u5e94\u5546\u6a21\u5757\u627e\u4e0d\u5230\u5bf9\u5e94\u7684sap\u7f16\u7801:" + mould.getMouldSupCompanySapCode() + ",\u5bfc\u5165\u5931\u8d25!"));
        mould.setMouldSupCompanyFullName(mouCompany.getCompanyFullName());
        mould.setMouldSupCompanyId(mouCompany.getId());
        mould.setMouldSupCompanyName(mouCompany.getCompanyName());
        mould.setMouldSupCompanySrmCode(mouCompany.getCompanyCode());
        Company conCompany = this.companyService.queryCompanyBySapCode(mould.getConceiveSupCompanySapCode());
        Assert.isNotNull((Object)conCompany, (String)("\u4f9b\u5e94\u5546\u6a21\u5757\u627e\u4e0d\u5230\u5bf9\u5e94\u7684sap\u7f16\u7801:" + mould.getConceiveSupCompanySapCode() + ",\u5bfc\u5165\u5931\u8d25!"));
        mould.setConceiveSupCompanyId(conCompany.getId());
        mould.setConceiveSupCompanyName(conCompany.getCompanyName());
        mould.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
        mould.setConceiveSupCompanyFullName(conCompany.getCompanyFullName());
        OrganizationExample ozExample = new OrganizationExample();
        ozExample.createCriteria().andOrganizationTypeEqualTo("T001").andCodeEqualTo(mould.getCompanyCode());
        List organizations = this.organizationService.queryAllObjByExample((IExample)ozExample);
        Assert.isNotEmpty((Collection)organizations, (String)("\u516c\u53f8\u4ee3\u7801" + mould.getCompanyCode() + "\u672a\u5728\u7cfb\u7edf\u7ef4\u62a4"));
        String description = ((Organization)organizations.get(0)).getDescription();
        mould.setCompanyName(description);
        if (StringUtils.isNotEmpty((String)mould.getBoard())) {
            BoardExample example = new BoardExample();
            example.createCriteria().andBoardNoEqualTo(mould.getBoard());
            List boards = this.boardService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)boards, (String)("\u673a\u53f0" + mould.getBoard() + "\u672a\u5728\u673a\u53f0\u4e3b\u6570\u636e\u7ef4\u62a4!"));
            mould.setBoardDesc(((Board)boards.get(0)).getBoardDesc());
        }
    }

    private void valid(Mould mould) {
        Assert.isNotBlank((String)mould.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mould.getMouldNumber(), (String)"\u6a21\u5177\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mould.getMouldNo(), (String)"\u6a21\u5177\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mould.getMouldDesc(), (String)"\u6a21\u5177\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mould.getMouldSupCompanySapCode(), (String)"\u6a21\u5177\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mould.getConceiveSupCompanySapCode(), (String)"\u6301\u6709\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)mould.getDesignedLifetime(), (String)"\u8bbe\u8ba1\u5bff\u547d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)mould.getDesignCapacity(), (String)"\u8bbe\u8ba1\u65e5\u4ea7\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mould.getMouldSpecifications(), (String)"\u6a21\u5177\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotNull((Object)mould.getCavityQuantity(), (String)"\u8154\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotNull((Object)mould.getCenterInterval(), (String)"\u4e2d\u5fc3\u8ddd\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    private void completeDemand(Mould mould, Company purCompany, String projectId, User user) {
        mould.setPurCompanyId(purCompany.getId());
        mould.setPurCompanySrmCode(purCompany.getCompanyCode());
        mould.setPurCompanyFullName(purCompany.getCompanyFullName());
        mould.setPurCompanySapCode(purCompany.getCompanySapCode());
        mould.setPurCompanyName(purCompany.getCompanyName());
        mould.setProjectId(projectId);
        mould.setCreateTime(new Date());
        mould.setCreateUserName(user.getNickName());
        mould.setIsAllot(Constant.NO_INT);
        mould.setMouldStatus(MouldStatus.USABLE.getCode());
        mould.setIsEnable(Constant.YES_INT);
        if (mould.getUsedLifetime() == null) {
            mould.setUsedLifetime(new BigDecimal(0));
        }
        BigDecimal subtract = mould.getDesignedLifetime().subtract(mould.getUsedLifetime()).setScale(2, 4);
        mould.setOverplusLifetime(subtract);
        mould.setTimeUnit("s");
        mould.setPropertyRight(mould.getCompanyName());
    }

    @Override
    @CacheEvict(value={"mould"}, allEntries=true)
    public void updateByExampleSelective(Mould mould, MouldExample example) {
        this.mouldMapper.updateByExampleSelective(mould, example);
    }
}

