/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.repair.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.utils.ExcelFileData;
import com.els.base.mould.repair.entity.Repair;
import com.els.base.mould.repair.entity.RepairExample;
import com.els.base.mould.repair.service.RepairService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
@Controller
@RequestMapping(value={"repair"})
public class RepairController {
    @Resource
    protected RepairService repairService;
    @Resource
    protected MouldInvorker mouldInvorker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Repair repair) {
        Assert.isNotNull((Object)repair, (String)"\u7ef4\u4fee\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.repairService.insert(repair, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355\u9884\u89c8\u6570\u636e")
    @RequestMapping(value={"service/prepare"})
    @ResponseBody
    public ResponseResult<Repair> prepareForPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6a21\u5177id\u4e0d\u80fd\u4e3a\u7a7a!");
        Repair repair = this.repairService.prepareForPur(ids, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)repair);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u4f5c\u5e9f\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @RequestMapping(value={"service/abolishForSup"})
    @ResponseBody
    public ResponseResult<String> abolishForSup(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.repairService.abolishSup(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5220\u9664\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @RequestMapping(value={"service/deleteByids"})
    @ResponseBody
    public ResponseResult<String> deleteByids(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.repairService.deleteByids(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u9001\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @RequestMapping(value={"service/sendToPur"})
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.repairService.sendToPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u786e\u8ba4\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @RequestMapping(value={"service/confirmForPur"})
    @ResponseBody
    public ResponseResult<String> confirmForPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.repairService.confirmForPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u62d2\u7edd\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @RequestMapping(value={"service/rejectForPur"})
    @ResponseBody
    public ResponseResult<String> rejectForPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.repairService.rejectForPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5b8c\u6210\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @RequestMapping(value={"service/confirmForSup"})
    @ResponseBody
    public ResponseResult<String> confirmForSup(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.repairService.confirmForSup(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Repair", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<Repair>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RepairExample example = new RepairExample();
        example.setPageView((PageView<Repair>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        RepairExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT).andPurCompanySrmCodeEqualTo(CompanyUtils.currentCompany().getCompanyCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.repairService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u6a21\u5177\u7ba1\u7406-\u6a21\u5177\u7ef4\u4fee\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Repair", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<Repair>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RepairExample example = new RepairExample();
        example.setPageView((PageView<Repair>)new PageView(pageNo, pageSize));
        example.setOrderByClause("APPLY_TIME DESC");
        RepairExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.repairService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        RepairExample example = new RepairExample();
        example.setOrderByClause("SEND_TIME DESC");
        RepairExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        List repairs = null;
        if (CollectionUtils.isEmpty(ids)) {
            if (CompanyUtils.isPurCompany()) {
                criteria.andSendStatusEqualTo(Constant.YES_INT);
            } else {
                criteria.andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
            }
            repairs = this.repairService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)repairs, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            if (CompanyUtils.isPurCompany()) {
                criteria.andSendStatusEqualTo(Constant.YES_INT).andIdIn((List)ids);
            } else {
                criteria.andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId()).andIdIn((List)ids);
            }
            repairs = this.repairService.queryAllObjByExample((IExample)example);
        }
        for (Repair repair : repairs) {
            if (repair.getRepairStatus() == 0) {
                repair.setPurRemark("\u672a\u786e\u8ba4");
            }
            if (repair.getRepairStatus() == 1) {
                repair.setPurRemark("\u5df2\u786e\u8ba4");
            }
            if (repair.getRepairStatus() == 2) {
                repair.setPurRemark("\u5b8c\u6210");
            }
            if (repair.getRepairStatus() == 3) {
                repair.setPurRemark("\u4f5c\u5e9f");
            }
            if (repair.getRepairStatus() == 4) {
                repair.setPurRemark("\u5173\u95ed");
            }
            if (repair.getSendStatus() == 1) {
                repair.setPurUserId("\u5df2\u53d1\u9001");
            }
            if (repair.getSendStatus() == 0) {
                repair.setPurUserId("\u672a\u53d1\u9001");
            }
            if (repair.getRepairWay() == 0) {
                repair.setSupUserId("\u81ea\u884c\u7ef4\u4fee");
            }
            if (repair.getRepairWay() != 1) continue;
            repair.setSupUserId("\u8fd4\u5382\u7ef4\u4fee");
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown((Repair)repairs.get(0));
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, repairs, "\u6a21\u5177\u7ef4\u4fee\u5355", "\u6a21\u5177\u7ef4\u4fee\u5355", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown(Repair repair) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ef4\u4fee\u5355\u53f7", (String)"repairNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u72b6\u6001", (String)"purRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u9001\u72b6\u6001", (String)"purUserId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177ID", (String)"mouldId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"mouldDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5e8f\u53f7", (String)"mouldNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"conceiveSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546\u5168\u79f0", (String)"conceiveSupCompanyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4", (String)"forecastCompleteTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ef4\u4fee\u65b9\u5f0f", (String)"supUserId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ef4\u4fee\u539f\u56e0", (String)"repairReason"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bf7\u4eba", (String)"applyUserName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7533\u8bf7\u65e5\u671f", (String)"applyTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u786e\u8ba4\u65e5\u671f", (String)"confirmTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b8c\u6210\u65e5\u671f", (String)"completedTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"conceiveSupRemark"));
        return titleAndModelKeys;
    }
}

