/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.master.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.master.command.CreateCommand;
import com.els.base.mould.roller.master.command.ModifyCommand;
import com.els.base.mould.roller.master.entity.Roller;
import com.els.base.mould.roller.master.entity.RollerExample;
import com.els.base.mould.roller.master.service.RollerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7248\u8f8a\u4e3b\u6570\u636e")
@Controller
@RequestMapping(value={"roller"})
public class RollerController {
    @Resource
    protected RollerService rollerService;
    @Resource
    private MouldInvorker mouldInvorker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7248\u8f8a\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Roller roller) {
        Assert.isNotNull((Object)roller, (String)"\u7248\u8f8a\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMouldCommand command = null;
        command = StringUtils.isEmpty((String)roller.getId()) ? new CreateCommand(roller) : new ModifyCommand(roller);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7248\u8f8a\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Roller roller) {
        Assert.isNotBlank((String)roller.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.rollerService.modifyObj(roller);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7248\u8f8a\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestParam(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        RollerExample example = new RollerExample();
        example.createCriteria().andIdIn((List)ids);
        this.rollerService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7248\u8f8a\u4e3b\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Roller", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Roller>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerExample example = new RollerExample();
        example.setPageView((PageView<Roller>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RollerExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7248\u8f8a\u4e3b\u6570\u636e(\u5305\u6750\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Roller", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/conFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<Roller>> conFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerExample example = new RollerExample();
        example.setPageView((PageView<Roller>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RollerExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7248\u8f8a\u4e3b\u6570\u636e(\u7248\u8f8a\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Roller", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/rollerFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<Roller>> rollerFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerExample example = new RollerExample();
        example.setPageView((PageView<Roller>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RollerExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPlateSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

