/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.scrap.command;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.master.entity.Roller;
import com.els.base.mould.roller.master.entity.RollerExample;
import com.els.base.mould.roller.scrap.entity.RollerScrap;
import com.els.base.mould.roller.scrap.utils.ConfirmStatus;
import com.els.base.mould.roller.utlis.RollerBillStatus;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RollerScrapCommand
extends AbstractMouldCommand<String> {
    private List<String> ids;

    public RollerScrapCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        RollerExample example = new RollerExample();
        example.createCriteria().andIdIn((List)this.ids);
        List rollers = mouldInvorker.getRollerService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)rollers, (String)"\u672a\u627e\u5230\u76f8\u5bf9\u5e94\u7684\u7248\u8f8a\u4e3b\u6570\u636e");
        Roller roller = (Roller)rollers.get(0);
        RollerScrap rollerScrap = new RollerScrap();
        this.vailad(roller);
        this.init(roller, rollerScrap);
        mouldInvorker.getRollerScrapService().addObj(rollerScrap);
        return null;
    }

    private void init(Roller roller, RollerScrap rollerScrap) {
        this.basic(roller, rollerScrap);
        rollerScrap.setPurCompanyId(roller.getPurCompanyId());
        rollerScrap.setPurCompanyName(roller.getPurCompanyName());
        rollerScrap.setPurCompanyFullName(roller.getPurCompanyFullName());
        rollerScrap.setPurCompanySapCode(roller.getPurCompanySapCode());
        rollerScrap.setPurCompanySrmCode(roller.getPurCompanySrmCode());
        rollerScrap.setConceiveSupCompanyId(roller.getConceiveSupCompanyId());
        rollerScrap.setConceiveSupCompanyName(roller.getConceiveSupCompanyName());
        rollerScrap.setConceiveSupCompanyFullName(roller.getConceiveSupCompanyFullName());
        rollerScrap.setConceiveSupCompanySapCode(roller.getConceiveSupCompanySapCode());
        rollerScrap.setConceiveSupCompanySrmCode(roller.getConceiveSupCompanySrmCode());
    }

    private void basic(Roller roller, RollerScrap rollerScrap) {
        rollerScrap.setId(UUIDGenerator.generateUUID());
        rollerScrap.setProjectId(roller.getProjectId());
        rollerScrap.setBillNo(UUIDGenerator.generateUUID());
        rollerScrap.setBillType("\u62a5\u5e9f");
        rollerScrap.setCompanyCode(roller.getCompanyCode());
        rollerScrap.setCompanyName(roller.getCompanyName());
        rollerScrap.setCreateTime(new Date());
        rollerScrap.setCreateName(SpringSecurityUtils.getLoginUser().getNickName());
        rollerScrap.setConfirmStatus(ConfirmStatus.NO_CONFIRM.getCode());
        rollerScrap.setPlateId(roller.getPlateId());
        rollerScrap.setPlateNo(roller.getPlateNo());
        rollerScrap.setPlateDesc(roller.getPlateDesc());
        rollerScrap.setPlateNumber(roller.getPlateNumber());
        rollerScrap.setIsEnable("N");
        rollerScrap.setSendStatus(Constant.NO_INT);
        rollerScrap.setPurRemark(roller.getPurRemark());
        rollerScrap.setPlateStats(roller.getPlateStats());
        rollerScrap.setClosingTime(roller.getClosingTime());
        rollerScrap.setDesignedLifetime(roller.getDesignedLifetime());
        rollerScrap.setUserLifetime(roller.getUserLifetime());
        rollerScrap.setSurplusLifetime(roller.getSurplusLifetime());
        rollerScrap.setApplyTime(roller.getApplyTime());
        rollerScrap.setApplyUserName(roller.getApplyName());
        rollerScrap.setScrappingMethod(Constant.NO_INT);
    }

    private void vailad(Roller roller) {
        if (roller.getPlateStats().equals(RollerBillStatus.ABOLISH.getCode())) {
            throw new CommonException("\u8be5\u7248\u8f8a\u5df2\u62a5\u5e9f\uff0c\u4e0d\u80fd\u751f\u6210\u5355\u636e");
        }
    }
}

