/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.scrap.service.impl;

import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.scrap.dao.ScrapMapper;
import com.els.base.mould.scrap.entity.Scrap;
import com.els.base.mould.scrap.entity.ScrapExample;
import com.els.base.mould.scrap.service.ScrapService;
import com.els.base.mould.scrap.utils.ConfirmStatus;
import com.els.base.mould.scrap.utils.ScrapBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultScrapService")
public class ScrapServiceImpl
implements ScrapService {
    @Resource
    protected ScrapMapper scrapMapper;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private MouldService mouldService;

    @CacheEvict(value={"scrap"}, allEntries=true)
    public void addObj(Scrap t) {
        this.scrapMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"scrap"}, allEntries=true)
    public void addAll(List<Scrap> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.scrapMapper.insertBatch(list);
    }

    @CacheEvict(value={"scrap"}, allEntries=true)
    public void deleteObjById(String id) {
        this.scrapMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"scrap"}, allEntries=true)
    public void deleteByExample(ScrapExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.scrapMapper.deleteByExample(example);
    }

    @CacheEvict(value={"scrap"}, allEntries=true)
    public void modifyObj(Scrap t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.scrapMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"scrap"}, keyGenerator="redisKeyGenerator")
    public Scrap queryObjById(String id) {
        return this.scrapMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"scrap"}, keyGenerator="redisKeyGenerator")
    public List<Scrap> queryAllObjByExample(ScrapExample example) {
        return this.scrapMapper.selectByExample(example);
    }

    @Cacheable(value={"scrap"}, keyGenerator="redisKeyGenerator")
    public PageView<Scrap> queryObjByPage(ScrapExample example) {
        PageView<Scrap> pageView = example.getPageView();
        pageView.setQueryResult(this.scrapMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"scrap"}, allEntries=true)
    public void sendToSup(List<String> ids, final com.els.base.auth.entity.User loginUser) {
        ScrapExample example = new ScrapExample();
        example.createCriteria().andIdIn((List)ids);
        List<Scrap> scrapList = this.scrapMapper.selectByExample(example);
        Assert.isNotEmpty(scrapList, (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6a21\u5177\u62a5\u5e9f\u5355");
        for (Scrap scrap : scrapList) {
            if (scrap.getConfirmStatus().equals(Constant.YES_INT)) {
                throw new CommonException("\u5df2\u786e\u8ba4\u62a5\u5e9f\u7684\u5355\u636e\u4e0d\u80fd\u53d1\u9001");
            }
            if (scrap.getSendStatus().equals(Constant.YES_INT)) {
                throw new CommonException("\u5df2\u53d1\u9001\u7684\u6a21\u5177\u62a5\u5e9f\u5355\u4e0d\u80fd\u91cd\u590d\u53d1\u9001");
            }
            if (scrap.getIsEnable().equals("Y")) {
                throw new CommonException("\u5df2\u5220\u9664\u7684\u6a21\u5177\u62a5\u5e9f\u5355\u4e0d\u80fd\u53d1\u9001");
            }
            scrap.setId(scrap.getId());
            scrap.setSendStatus(Constant.YES_INT);
            scrap.setSendTime(new Date());
            scrap.setApplyUserName(loginUser.getNickName());
            scrap.setApplyTime(new Date());
            this.scrapMapper.updateByPrimaryKeySelective(scrap);
        }
        List<Scrap> list = this.queryAllObjByExample(example);
        for (final Scrap scrap : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    ScrapServiceImpl.this.sendMessagesToPur(loginUser, scrap, ScrapBusinessEnum.SUP_SCRAP_SEND.getCode());
                }
            });
        }
    }

    protected void sendMessagesToPur(com.els.base.auth.entity.User loginUser, Scrap data, String businessType) {
        User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @Transactional
    @CacheEvict(value={"scrap"}, allEntries=true)
    public void rejectForPur(List<String> ids, com.els.base.auth.entity.User loginUser) {
        ScrapExample example = new ScrapExample();
        example.createCriteria().andIdIn((List)ids);
        List<Scrap> scrapList = this.scrapMapper.selectByExample(example);
        Assert.isNotEmpty(scrapList, (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6a21\u5177\u62a5\u5e9f\u5355");
        for (Scrap scrap : scrapList) {
            if (!ConfirmStatus.NO_CONFIRM.getValue().equals(scrap.getConfirmStatus())) {
                throw new CommonException("\u53ea\u6709\u672a\u786e\u8ba4\u7684\u5355\u636e\u624d\u5141\u8bb8\u9000\u56de\uff01");
            }
            scrap.setId(scrap.getId());
            scrap.setConfirmStatus(ConfirmStatus.REJECT.getValue());
            scrap.setMouldStatus(MouldStatus.USABLE.getCode());
            this.scrapMapper.updateByPrimaryKeySelective(scrap);
            MouldExample example2 = new MouldExample();
            example2.createCriteria().andMouldIdEqualTo(scrap.getMouldId());
            List moulds = this.mouldService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)moulds, (String)"\u6a21\u5177\u4e3b\u6570\u636e\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177\uff01");
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.USABLE.getCode());
                this.mouldService.modifyObj(mould);
            }
            this.sendMessagesToConceiveSup(loginUser, scrap, ScrapBusinessEnum.PUR_SCRAP_REJECT.getCode());
        }
    }

    private void sendMessagesToConceiveSup(com.els.base.auth.entity.User loginUser, Scrap data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }
}

