/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.board.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.mould.board.dao.BoardMapper;
import com.els.base.mould.board.entity.Board;
import com.els.base.mould.board.entity.BoardExample;
import com.els.base.mould.board.service.BoardService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBoardService")
public class BoardServiceImpl
implements BoardService {
    @Resource
    protected BoardMapper boardMapper;

    @CacheEvict(value={"board"}, allEntries=true)
    public void addObj(Board t) {
        this.boardMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"board"}, allEntries=true)
    public void addAll(List<Board> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.boardMapper.insertBatch(list);
    }

    @CacheEvict(value={"board"}, allEntries=true)
    public void deleteObjById(String id) {
        this.boardMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"board"}, allEntries=true)
    public void deleteByExample(BoardExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.boardMapper.deleteByExample(example);
    }

    @CacheEvict(value={"board"}, allEntries=true)
    public void modifyObj(Board t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.boardMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"board"}, keyGenerator="redisKeyGenerator")
    public Board queryObjById(String id) {
        return this.boardMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"board"}, keyGenerator="redisKeyGenerator")
    public List<Board> queryAllObjByExample(BoardExample example) {
        return this.boardMapper.selectByExample(example);
    }

    @Cacheable(value={"board"}, keyGenerator="redisKeyGenerator")
    public PageView<Board> queryObjByPage(BoardExample example) {
        PageView<Board> pageView = example.getPageView();
        pageView.setQueryResult(this.boardMapper.selectByExampleByPage(example));
        return pageView;
    }
}

