/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.check.command;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.mould.check.entity.Check;
import com.els.base.mould.check.entity.CheckExample;
import com.els.base.mould.check.entity.CheckItem;
import com.els.base.mould.check.entity.CheckItemExample;
import com.els.base.mould.check.utils.CheckBusinsessEnum;
import com.els.base.mould.check.utils.CheckStatus;
import com.els.base.mould.check.utils.SendStatus;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public class ConCheckResultCommand
extends AbstractMouldCommand<String> {
    private List<String> ids;
    private User user;

    public ConCheckResultCommand(List<String> ids, User user) {
        this.ids = ids;
        this.user = user;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        CheckExample example = new CheckExample();
        example.createCriteria().andIdIn((List)this.ids);
        List ids = this.mouldInvorker.getCheckService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)ids, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76d8\u70b9\u901a\u77e5\u5355");
        for (Check check : ids) {
            if (!SendStatus.RESULT_SEND.getCode().equals(check.getSendStatus())) {
                throw new CommonException("\u5355\u53f7\uff1a" + check.getCheckNo() + "\u76d8\u70b9\u7ed3\u679c\u672a\u53d1\u9001,\u4e0d\u5141\u8bb8\u786e\u8ba4");
            }
            check.setId(check.getId());
            check.setCheckStatus(CheckStatus.CON_COMPLETION.getCode());
            this.mouldInvorker.getCheckService().modifyObj(check);
            CheckItemExample itemExample = new CheckItemExample();
            itemExample.createCriteria().andCheckIdEqualTo(check.getId());
            List items = this.mouldInvorker.getCheckItemService().queryAllObjByExample((IExample)itemExample);
            Assert.isNotEmpty((Collection)items, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76d8\u70b9\u901a\u77e5\u5355\u884c\u6570\u636e");
            for (CheckItem checkItem : items) {
                MouldExample example2 = new MouldExample();
                example2.createCriteria().andMouldIdEqualTo(checkItem.getMouldId());
                List moulds = this.mouldInvorker.getMouldService().queryAllObjByExample((IExample)example2);
                for (Mould mould : moulds) {
                    mould.setId(mould.getId());
                    mould.setUsedLifetime(checkItem.getUsedLifetime());
                    if (checkItem.getDesignedLifetime() == null) {
                        checkItem.setDesignedLifetime(new BigDecimal(0));
                    }
                    if (checkItem.getUsedLifetime() == null) {
                        checkItem.setUsedLifetime(new BigDecimal(0));
                    }
                    mould.setDesignedLifetime(checkItem.getDesignedLifetime());
                    mould.setUsedLifetime(checkItem.getUsedLifetime());
                    mould.setOverplusLifetime(mould.getDesignedLifetime().subtract(mould.getUsedLifetime()).setScale(2, 4));
                    mould.setMouldStatus(checkItem.getUpdatStatus());
                    mould.setLastCountDate(check.getCheckTime());
                    this.mouldInvorker.getMouldService().modifyObj(mould);
                }
            }
            this.sendMessagesToConceiveSup(this.user, check, CheckBusinsessEnum.RESULT_PUR_CONFIRM.getCode());
        }
        return null;
    }

    private void sendMessagesToConceiveSup(User loginUser, Check check, String businessType) {
        User supUser = this.mouldInvorker.getCompanyUserRefService().queryMainUserOfCompany(check.getConceiveSupCompanyId());
        Message message = Message.init((Object)check).setBusinessTypeCode(businessType).setCompanyCode(check.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }
}

