/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.command;

import com.els.base.company.entity.Company;
import com.els.base.core.utils.Assert;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.Mould;
import java.math.BigDecimal;
import java.util.Date;

public class ModifyCommand
extends AbstractMouldCommand<String> {
    private Mould mould;

    public ModifyCommand(Mould mould) {
        this.mould = mould;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valid(this.mould);
        this.complete(this.mould);
        mouldInvorker.getMouldService().modifyObj(this.mould);
        return null;
    }

    private void complete(Mould mould) {
        this.completeSupAndPur();
        this.completeInfo();
    }

    private void completeInfo() {
        this.mould.setUpdateTime(new Date());
        this.mould.setUpdateUserName(this.getPurUser().getNickName());
        if (this.mould.getDesignedLifetime() == null) {
            this.mould.setDesignedLifetime(new BigDecimal(0));
        }
        if (this.mould.getUsedLifetime() == null) {
            this.mould.setUsedLifetime(new BigDecimal(0));
        }
        BigDecimal subtract = this.mould.getDesignedLifetime().subtract(this.mould.getUsedLifetime()).setScale(2, 4);
        this.mould.setOverplusLifetime(subtract);
    }

    private void completeSupAndPur() {
        Company mouCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.mould.getMouldSupCompanySapCode());
        this.mould.setMouldSupCompanyId(mouCompany.getId());
        this.mould.setMouldSupCompanyName(mouCompany.getCompanyName());
        this.mould.setMouldSupCompanySrmCode(mouCompany.getCompanyCode());
        Company conCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.mould.getConceiveSupCompanySapCode());
        this.mould.setConceiveSupCompanyId(conCompany.getId());
        this.mould.setConceiveSupCompanyName(conCompany.getCompanyName());
        this.mould.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
    }

    private void valid(Mould mould) {
        Company purCompany2 = this.getPurCompany();
        if (purCompany2.getId().equals(mould.getConceiveSupCompanyId())) {
            Assert.isNotNull((Object)mould.getActuallyCapacity(), (String)"\u5b9e\u9645\u65e5\u4ea7\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Assert.isNotBlank((String)mould.getMouldNo(), (String)"\u6a21\u5177\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull((Object)mould.getMouldStatus(), (String)"\u6a21\u5177\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)mould.getMouldDesc(), (String)"\u6a21\u5177\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotBlank((String)mould.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotBlank((String)mould.getMouldSupCompanySapCode(), (String)"\u6a21\u5177\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotBlank((String)mould.getConceiveSupCompanySapCode(), (String)"\u6301\u6709\u4f9b\u5e94\u5546sap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull((Object)mould.getDesignCapacity(), (String)"\u8bbe\u8ba1\u65e5\u4ea7\u80fd\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotBlank((String)mould.getMouldSpecifications(), (String)"\u6a21\u5177\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull((Object)mould.getCavityQuantity(), (String)"\u8154\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull((Object)mould.getCenterInterval(), (String)"\u4e2d\u5fc3\u8ddd\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

