/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.command;

import com.els.base.company.entity.Company;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.entity.RollerFormFile;
import com.els.base.mould.roller.entity.RollerNotice;
import com.els.base.mould.roller.entity.RollerNoticeItem;
import com.els.base.mould.roller.entity.RollerNoticeItemExample;
import com.els.base.mould.roller.master.entity.RollerExample;
import com.els.base.mould.roller.utlis.RollerBillStatus;
import com.els.base.mould.roller.utlis.RollerConfirmStatus;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateCommand
extends AbstractMouldCommand<String> {
    private RollerNotice rollerNotice;

    public CreateCommand(RollerNotice rollerNotice) {
        this.rollerNotice = rollerNotice;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valiad(this.rollerNotice);
        this.compele(this.rollerNotice);
        mouldInvorker.getRollerNoticeService().addObj(this.rollerNotice);
        List<RollerNoticeItem> items = this.rollerNotice.getNoticeItems();
        for (RollerNoticeItem rollerNoticeItem : items) {
            mouldInvorker.getRollerNoticeItemService().addObj(rollerNoticeItem);
            List<RollerFormFile> files = rollerNoticeItem.getFiles();
            if (!CollectionUtils.isNotEmpty(files)) continue;
            for (RollerFormFile rollerFormFile : files) {
                mouldInvorker.getRollerFormFileService().addObj(rollerFormFile);
            }
        }
        return null;
    }

    private void compele(RollerNotice rollerNotice) {
        this.compeleSupAndPur();
        this.init();
    }

    private void init() {
        this.rollerNotice.setId(UUIDGenerator.generateUUID());
        this.rollerNotice.setSendStatus(Constant.NO_INT);
        this.rollerNotice.setBillStatus(RollerBillStatus.BUILD.getValue());
        this.rollerNotice.setRollerNo(UUIDGenerator.generateUUID());
        if (this.rollerNotice.getApplyTime() == null) {
            this.rollerNotice.setApplyTime(new Date());
        }
        this.rollerNotice.setCreateTime(new Date());
        this.rollerNotice.setCreateName(this.getPurUser().getNickName());
        this.rollerNotice.setIsEnable("N");
        this.rollerNotice.setConfirmStatus(RollerConfirmStatus.NO_CONFIRM.getCode());
        this.rollerNotice.setProjectId(ProjectUtils.getProjectId());
        this.rollerNotice.setApproveStatus(Constant.NO_INT);
        BigDecimal includeTaxAmount = new BigDecimal(0);
        BigDecimal taxAmount = new BigDecimal(0);
        List<RollerNoticeItem> noticeItems = this.rollerNotice.getNoticeItems();
        for (int n = 0; n < noticeItems.size(); ++n) {
            RollerNoticeItem item = noticeItems.get(n);
            this.completeItem(item);
            this.completeon(item, n, includeTaxAmount, taxAmount);
            List<RollerFormFile> files = item.getFiles();
            if (!CollectionUtils.isNotEmpty(files)) continue;
            files.forEach(i -> {
                i.setId(UUIDGenerator.generateUUID());
                i.setRollerId(this.rollerNotice.getId());
                i.setRollerNo(this.rollerNotice.getRollerNo());
                i.setRollerItemNo(item.getItemNo());
                i.setIsEnable(Constant.YES_INT);
                i.setUploadDate(new Date());
                i.setUploadUserName(this.getPurUser().getNickName());
            });
        }
        this.rollerNotice.setIncludeTaxAmount(includeTaxAmount);
        this.rollerNotice.setTaxAmount(taxAmount);
    }

    private void completeon(RollerNoticeItem item, int n, BigDecimal includeTaxAmount, BigDecimal taxAmount) {
        item.setId(UUIDGenerator.generateUUID());
        item.setConfirmStatus(RollerConfirmStatus.NO_CONFIRM.getCode());
        item.setNoticeNo(this.rollerNotice.getRollerNo());
        item.setItemNo(UUIDGenerator.generateUUID());
        item.setCompanyCode(this.rollerNotice.getCompanyCode());
        item.setCompanyName(this.rollerNotice.getCompanyName());
        item.setIsEnable("N");
        item.setNoticeId(this.rollerNotice.getId());
        String rollerNo = item.getRollerNo();
        RollerExample example = new RollerExample();
        example.createCriteria().andPlateIdLike(rollerNo + "___");
        int i = this.mouldInvorker.getRollerService().countByExample(example);
        RollerNoticeItemExample example2 = new RollerNoticeItemExample();
        example2.createCriteria().andRollerIdLike(rollerNo + "___");
        int j = this.mouldInvorker.getRollerNoticeItemService().countByExample(example2);
        String id = null;
        id = n == 0 ? String.format("%s%03d", rollerNo, i + j + n + 1) : String.format("%s%03d", rollerNo, i + j + 1);
        item.setRollerId(id);
        if (item.getPlateQuantity() == null) {
            item.setPlateQuantity(new BigDecimal(0));
        }
        if (item.getTaxPrice() == null) {
            item.setTaxPrice(new BigDecimal(0));
        }
        if (item.getPlateQuantity() == null || item.getIncludeTaxAmount() == null) {
            item.setIncludeTaxAmount(new BigDecimal(0));
        }
        if (item.getTaxAmount() == null) {
            item.setTaxAmount(new BigDecimal(0));
        }
        includeTaxAmount.add(item.getIncludeTaxAmount());
        taxAmount.add(item.getTaxAmount());
    }

    private void completeItem(RollerNoticeItem item) {
        item.setPurCompanyId(this.rollerNotice.getPurCompanyId());
        item.setPurCompanyFullName(this.rollerNotice.getPurCompanyFullName());
        item.setPurCompanyName(this.rollerNotice.getPurCompanyName());
        item.setPurCompanySrmCode(this.rollerNotice.getPurCompanySrmCode());
        item.setRollerSupCompanyId(this.rollerNotice.getRollerSupCompanyId());
        item.setRollerSupCompanyName(this.rollerNotice.getRollerSupCompanyName());
        item.setRollerSupCompanyFullName(this.rollerNotice.getRollerSupCompanyFullName());
        item.setRollerSupCompanySapCode(this.rollerNotice.getRollerSupCompanySapCode());
        item.setRollerSupCompanySrmCode(this.rollerNotice.getRollerSupCompanySrmCode());
        item.setConceiveSupCompanyId(this.rollerNotice.getConceiveSupCompanyId());
        item.setConceiveSupCompanyName(this.rollerNotice.getConceiveSupCompanyName());
        item.setConceiveSupCompanyFullName(this.rollerNotice.getConceiveSupCompanyFullName());
        item.setConceiveSupCompanySapCode(this.rollerNotice.getConceiveSupCompanySapCode());
        item.setConceiveSupCompanySrmCode(this.rollerNotice.getConceiveSupCompanySrmCode());
    }

    private void compeleSupAndPur() {
        Company purCompany = this.getPurCompany();
        this.rollerNotice.setPurCompanyId(purCompany.getId());
        this.rollerNotice.setPurCompanyFullName(purCompany.getCompanyFullName());
        this.rollerNotice.setPurCompanyName(purCompany.getCompanyName());
        this.rollerNotice.setPurCompanySrmCode(purCompany.getCompanyCode());
        Company rollerCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.rollerNotice.getRollerSupCompanySapCode());
        this.rollerNotice.setRollerSupCompanyId(rollerCompany.getId());
        this.rollerNotice.setRollerSupCompanyName(rollerCompany.getCompanyName());
        this.rollerNotice.setRollerSupCompanyFullName(rollerCompany.getCompanyFullName());
        this.rollerNotice.setRollerSupCompanySapCode(rollerCompany.getCompanySapCode());
        this.rollerNotice.setRollerSupCompanySrmCode(rollerCompany.getCompanyCode());
        Company conCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.rollerNotice.getConceiveSupCompanySapCode());
        this.rollerNotice.setConceiveSupCompanyId(conCompany.getId());
        this.rollerNotice.setConceiveSupCompanyName(conCompany.getCompanyName());
        this.rollerNotice.setConceiveSupCompanyFullName(conCompany.getCompanyFullName());
        this.rollerNotice.setConceiveSupCompanySapCode(conCompany.getCompanySapCode());
        this.rollerNotice.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
    }

    private void valiad(RollerNotice rollerNotice) {
        Assert.isNotBlank((String)rollerNotice.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)rollerNotice.getRollerSupCompanySapCode(), (String)"\u5236\u7248\u4f9b\u5e94\u5546SAP#\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)rollerNotice.getConceiveSupCompanySapCode(), (String)"\u63a5\u6536\u4f9b\u5e94\u5546SAP#\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<RollerNoticeItem> noticeItems = rollerNotice.getNoticeItems();
        Assert.isNotEmpty(noticeItems, (String)"\u5236\u7248\u901a\u77e5\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        noticeItems.forEach(n -> {
            Assert.isNotBlank((String)n.getRollerNo(), (String)"\u7248\u8f8a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)n.getRequiredDeliveryTime(), (String)"\u8981\u6c42\u4ea4\u7248\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)n.getPlateQuantity(), (String)"\u5236\u7248\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }
}

