/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.command.CreateCommand;
import com.els.base.mould.roller.command.DeleteCommand;
import com.els.base.mould.roller.command.ModifyCommand;
import com.els.base.mould.roller.entity.RollerFormFile;
import com.els.base.mould.roller.entity.RollerNotice;
import com.els.base.mould.roller.entity.RollerNoticeExample;
import com.els.base.mould.roller.entity.RollerNoticeItem;
import com.els.base.mould.roller.service.RollerFormFileService;
import com.els.base.mould.roller.service.RollerNoticeItemService;
import com.els.base.mould.roller.service.RollerNoticeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7248\u8f8a\u7ba1\u7406\u2014\u5236\u7248\u901a\u77e5\u5355")
@Controller
@RequestMapping(value={"rollerNotice"})
public class RollerNoticeController {
    @Resource
    protected RollerNoticeService rollerNoticeService;
    @Resource
    protected RollerNoticeItemService rollerNoticeItemService;
    @Resource
    protected RollerFormFileService rollerFormFileService;
    @Resource
    protected MouldInvorker mouldInvorker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7248\u8f8a\u7ba1\u7406\u2014\u5236\u7248\u901a\u77e5\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody RollerNotice rollerNotice) {
        Assert.isNotNull((Object)rollerNotice, (String)"\u5236\u7248\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMouldCommand command = null;
        command = StringUtils.isEmpty((String)rollerNotice.getId()) ? new CreateCommand(rollerNotice) : new ModifyCommand(rollerNotice);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser(SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u53d1\u9001\u2014\u5236\u7248\u901a\u77e5\u5355")
    @RequestMapping(value={"service/sendToSup"})
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        User loginUser = SpringSecurityUtils.getLoginUser();
        this.rollerNoticeService.sendToSup(ids, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7248\u8f8a\u7ba1\u7406\u2014\u5236\u7248\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteCommand command = new DeleteCommand(ids);
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u7248\u8f8a\u7ba1\u7406\u2014\u5236\u7248\u901a\u77e5\u5355")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        User loginUser = SpringSecurityUtils.getLoginUser();
        this.rollerNoticeService.abolish(ids, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u2014\u5236\u7248\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RollerNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/purFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RollerNotice>> purFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerNoticeExample example = new RollerNoticeExample();
        example.setPageView((PageView<RollerNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RollerNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerNoticeService.queryObjByPage((IExample)example);
        List<RollerNotice> noticeItemList = this.getNoticeItemList(pageData.getQueryResult());
        pageData.setQueryResult(noticeItemList);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7248\u8f8a\u4f9b\u5e94\u5546\u67e5\u8be2\u2014\u5236\u7248\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RollerNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/rollerFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RollerNotice>> rollerFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerNoticeExample example = new RollerNoticeExample();
        example.setPageView((PageView<RollerNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RollerNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N").andSendStatusEqualTo(Constant.YES_INT).andRollerSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerNoticeService.queryObjByPage((IExample)example);
        List<RollerNotice> noticeItemList = this.getNoticeItemList(pageData.getQueryResult());
        pageData.setQueryResult(noticeItemList);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6301\u6709\u4f9b\u5e94\u5546\u67e5\u8be2\u2014\u5236\u7248\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RollerNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/conFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RollerNotice>> conFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerNoticeExample example = new RollerNoticeExample();
        example.setPageView((PageView<RollerNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RollerNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N").andSendStatusEqualTo(Constant.YES_INT).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerNoticeService.queryObjByPage((IExample)example);
        List<RollerNotice> noticeItemList = this.getNoticeItemList(pageData.getQueryResult());
        pageData.setQueryResult(noticeItemList);
        return ResponseResult.success((Object)pageData);
    }

    private List<RollerNotice> getNoticeItemList(List<RollerNotice> rollerNotices) {
        ArrayList<RollerNotice> items = new ArrayList<RollerNotice>();
        if (CollectionUtils.isEmpty(rollerNotices)) {
            return items;
        }
        for (RollerNotice rollerNotice : rollerNotices) {
            List<RollerNoticeItem> noticeItem = this.rollerNoticeItemService.queryByNoticeId(rollerNotice.getId());
            for (RollerNoticeItem rollerNoticeItem : noticeItem) {
                List<RollerFormFile> fileList = this.rollerFormFileService.queryByRollerItemNo(rollerNoticeItem.getItemNo());
                rollerNoticeItem.setFiles(fileList);
            }
            rollerNotice.setNoticeItems(noticeItem);
            items.add(rollerNotice);
        }
        return items;
    }
}

